/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.service;

import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.impl.StandardServiceManager;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.IndexingMode;
import org.hibernate.search.test.engine.service.FooService;
import org.hibernate.search.test.engine.service.NonExistentService;
import org.hibernate.search.test.engine.service.ProgrammaticallyConfiguredSimpleService;
import org.hibernate.search.test.engine.service.ServiceWithMultipleImplementations;
import org.hibernate.search.test.engine.service.SimpleService;
import org.hibernate.search.test.engine.service.SimpleServiceImpl;
import org.hibernate.search.test.engine.service.StartableService;
import org.hibernate.search.test.engine.service.StartableServiceImpl;
import org.hibernate.search.test.engine.service.StoppableService;
import org.hibernate.search.test.engine.service.StoppableServiceImpl;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.junit.rules.ExpectedException;

public class StandardServiceManagerTest {
    @Rule
    public SearchFactoryHolder searchFactoryHolder = new SearchFactoryHolder(new Class[0]);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private SearchConfigurationForTest searchConfiguration;
    private ServiceManager serviceManagerUnderTest;

    @Before
    public void setUp() {
        this.searchConfiguration = new SearchConfigurationForTest();
        this.serviceManagerUnderTest = new StandardServiceManager((SearchConfiguration)this.searchConfiguration, (BuildContext)new DummyBuildContext());
    }

    @Test
    public void testUnavailableServiceThrowsException() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage(JUnitMatchers.containsString((String)"HSEARCH000196"));
        this.serviceManagerUnderTest.requestService(NonExistentService.class);
    }

    @Test
    public void testNullParameterForRequestServiceThrowsException() {
        this.thrown.expect(IllegalArgumentException.class);
        this.serviceManagerUnderTest.requestService(null);
    }

    @Test
    public void testNullParameterForReleaseServiceThrowsException() {
        this.thrown.expect(IllegalArgumentException.class);
        this.serviceManagerUnderTest.releaseService(null);
    }

    @Test
    public void testMultipleServiceImplementationsThrowsException() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage(JUnitMatchers.containsString((String)"HSEARCH000195"));
        this.serviceManagerUnderTest.requestService(ServiceWithMultipleImplementations.class);
    }

    @Test
    public void testRetrieveService() {
        SimpleService simpleService = (SimpleService)this.serviceManagerUnderTest.requestService(SimpleService.class);
        Assert.assertNotNull((String)"The service should be created", (Object)simpleService);
        Assert.assertTrue((boolean)(simpleService instanceof SimpleServiceImpl));
    }

    @Test
    public void testStartServiceIsPerformed() {
        StartableService service = (StartableService)this.serviceManagerUnderTest.requestService(StartableService.class);
        Assert.assertNotNull((String)"The service should be created", (Object)service);
        Assert.assertTrue((boolean)(service instanceof StartableServiceImpl));
        Assert.assertTrue((String)"Service should have been started", (boolean)((StartableServiceImpl)service).isStarted());
    }

    @Test
    public void testStopServiceIsPerformed() {
        StoppableService service = (StoppableService)this.serviceManagerUnderTest.requestService(StoppableService.class);
        Assert.assertNotNull((String)"The service should be created", (Object)service);
        Assert.assertTrue((boolean)(service instanceof StoppableServiceImpl));
        this.serviceManagerUnderTest.releaseService(StoppableService.class);
        Assert.assertTrue((String)"Service should have been stopped", (boolean)((StoppableServiceImpl)service).isStopped());
    }

    @Test
    public void testServiceInstanceIsCached() {
        SimpleService simpleService1 = (SimpleService)this.serviceManagerUnderTest.requestService(SimpleService.class);
        Assert.assertNotNull((String)"The service should be created", (Object)simpleService1);
        SimpleService simpleService2 = (SimpleService)this.serviceManagerUnderTest.requestService(SimpleService.class);
        Assert.assertNotNull((String)"The service should be created", (Object)simpleService2);
        Assert.assertTrue((String)"The same service instance should have been returned", (simpleService1 == simpleService2 ? 1 : 0) != 0);
    }

    @Test
    public void providedServicesHavePrecedence() {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest();
        configuration.getProvidedServices().put(SimpleService.class, new ProgrammaticallyConfiguredSimpleService());
        this.serviceManagerUnderTest = new StandardServiceManager((SearchConfiguration)configuration, (BuildContext)new DummyBuildContext());
        SimpleService simpleService = (SimpleService)this.serviceManagerUnderTest.requestService(SimpleService.class);
        Assert.assertNotNull((String)"The service should be created", (Object)simpleService);
        Assert.assertTrue((String)("Wrong service type: " + simpleService.getClass()), (boolean)(simpleService instanceof ProgrammaticallyConfiguredSimpleService));
    }

    @Test
    public void testCircularServiceDependencyThrowsException() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage(JUnitMatchers.containsString((String)"HSEARCH000198"));
        this.serviceManagerUnderTest.requestService(FooService.class);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1547")
    public void testRequestingServiceAfterReleaseAllThrowsException() {
        SimpleService simpleService1 = (SimpleService)this.serviceManagerUnderTest.requestService(SimpleService.class);
        Assert.assertNotNull((String)"The service should be created", (Object)simpleService1);
        this.serviceManagerUnderTest.releaseAllServices();
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage(JUnitMatchers.containsString((String)"HSEARCH000209"));
        this.serviceManagerUnderTest.requestService(SimpleService.class);
    }

    private class DummyBuildContext
    implements BuildContext {
        private DummyBuildContext() {
        }

        public ExtendedSearchIntegrator getUninitializedSearchIntegrator() {
            return null;
        }

        public String getIndexingStrategy() {
            return null;
        }

        public IndexingMode getIndexingMode() {
            return null;
        }

        public ServiceManager getServiceManager() {
            return StandardServiceManagerTest.this.serviceManagerUnderTest;
        }

        public IndexManagerHolder getAllIndexesManager() {
            return null;
        }

        public ErrorHandler getErrorHandler() {
            return null;
        }
    }
}

