/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id.providedId;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.engine.QueryTimeoutException;
import org.hibernate.search.query.engine.impl.DocumentExtractorImpl;
import org.hibernate.search.query.engine.impl.LazyQueryState;
import org.hibernate.search.query.engine.impl.QueryFilters;
import org.hibernate.search.query.engine.impl.QueryHits;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.test.id.providedId.ProvidedIdPerson;
import org.hibernate.search.test.id.providedId.ProvidedIdPersonSub;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class ProvidedIdTest {
    @Rule
    public SearchFactoryHolder configuration = new SearchFactoryHolder(ProvidedIdPerson.class, ProvidedIdPersonSub.class);

    @Test
    public void testProvidedId() throws Exception {
        ExtendedSearchIntegrator extendedIntegrator = this.configuration.getSearchFactory();
        ProvidedIdPerson person1 = new ProvidedIdPerson();
        person1.setName("Big Goat");
        person1.setBlurb("Eats grass");
        ProvidedIdPerson person2 = new ProvidedIdPerson();
        person2.setName("Mini Goat");
        person2.setBlurb("Eats cheese");
        ProvidedIdPersonSub person3 = new ProvidedIdPersonSub();
        person3.setName("Regular goat");
        person3.setBlurb("Is anorexic");
        TransactionContextForTest tc = new TransactionContextForTest();
        Work work = new Work((Object)person1, (Serializable)Integer.valueOf(1), WorkType.INDEX);
        extendedIntegrator.getWorker().performWork(work, (TransactionContext)tc);
        work = new Work((Object)person2, (Serializable)Integer.valueOf(2), WorkType.INDEX);
        extendedIntegrator.getWorker().performWork(work, (TransactionContext)tc);
        Work work2 = new Work((Object)person3, (Serializable)Integer.valueOf(3), WorkType.INDEX);
        extendedIntegrator.getWorker().performWork(work2, (TransactionContext)tc);
        tc.end();
        QueryParser parser = new QueryParser("name", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("Goat");
        IndexReader indexReader = extendedIntegrator.getIndexReaderAccessor().open(new Class[]{ProvidedIdPerson.class});
        IndexSearcher searcher = new IndexSearcher(indexReader);
        TopDocs hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)3L, (long)hits.totalHits);
        ClassicSimilarity defaultSimilarity = new ClassicSimilarity();
        LazyQueryState lowLevelSearcher = new LazyQueryState(luceneQuery, QueryFilters.EMPTY_FILTERSET, indexReader, (Similarity)defaultSimilarity, extendedIntegrator, extendedIntegrator.getIndexedTypes(), false, false);
        QueryHits queryHits = new QueryHits(lowLevelSearcher, null, null, new TimeoutManagerImpl((Object)luceneQuery, QueryTimeoutException.DEFAULT_TIMEOUT_EXCEPTION_FACTORY, extendedIntegrator.getTimingSource()), null, null, null, null);
        HashSet<String> identifiers = new HashSet<String>();
        identifiers.add("providedId");
        HashSet<Class> targetedClasses = new HashSet<Class>();
        targetedClasses.add(ProvidedIdPerson.class);
        targetedClasses.add(ProvidedIdPersonSub.class);
        DocumentExtractorImpl extractor = new DocumentExtractorImpl(queryHits, extendedIntegrator, new String[]{"name"}, identifiers, false, lowLevelSearcher, 0, 0, targetedClasses);
        HashSet<String> titles = new HashSet<String>(3);
        for (int id = 0; id < hits.totalHits; ++id) {
            String projectedTitle = (String)extractor.extract(id).getProjection()[0];
            Assert.assertNotNull((Object)projectedTitle);
            titles.add(projectedTitle);
        }
        Assert.assertTrue((boolean)titles.contains("Regular goat"));
        Assert.assertTrue((boolean)titles.contains("Mini Goat"));
        Assert.assertTrue((boolean)titles.contains("Big Goat"));
        extendedIntegrator.getIndexReaderAccessor().close(indexReader);
    }
}

