/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.setup;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.cfg.spi.SearchConfigurationBase;
import org.hibernate.search.engine.service.classloading.impl.DefaultClassLoaderService;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.spi.DefaultInstanceInitializer;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.setup.TestDefaults;

public class SearchConfigurationForTest
extends SearchConfigurationBase
implements SearchConfiguration {
    private final Map<String, Class<?>> classes;
    private final Properties properties;
    private final HashMap<Class<? extends Service>, Object> providedServices;
    private final InstanceInitializer initializer;
    private SearchMapping programmaticMapping;
    private boolean transactionsExpected = true;
    private boolean indexMetadataComplete = true;
    private boolean deleteByTermEnforced = false;
    private boolean idProvidedImplicit = false;
    private boolean multitenancyEnabled = false;
    private ClassLoaderService classLoaderService;

    public SearchConfigurationForTest() {
        this(DefaultInstanceInitializer.DEFAULT_INITIALIZER);
    }

    public SearchConfigurationForTest(InstanceInitializer init) {
        this.initializer = init;
        this.classes = new HashMap();
        this.properties = TestDefaults.getProperties();
        this.providedServices = new HashMap();
        this.classLoaderService = new DefaultClassLoaderService();
        this.addProperty("hibernate.search.default.directory_provider", "ram");
        this.addProperty("hibernate.search.lucene_version", TestConstants.getTargetLuceneVersion().toString());
    }

    public SearchConfigurationForTest addProperty(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public SearchConfigurationForTest addClass(Class<?> indexed) {
        this.classes.put(indexed.getName(), indexed);
        return this;
    }

    public SearchConfigurationForTest addClasses(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.addClass(clazz);
        }
        return this;
    }

    public Iterator<Class<?>> getClassMappings() {
        return this.classes.values().iterator();
    }

    public Class<?> getClassMapping(String name) {
        return this.classes.get(name);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ReflectionManager getReflectionManager() {
        return null;
    }

    public SearchMapping getProgrammaticMapping() {
        return this.programmaticMapping;
    }

    public SearchConfigurationForTest setProgrammaticMapping(SearchMapping programmaticMapping) {
        this.programmaticMapping = programmaticMapping;
        return this;
    }

    public Map<Class<? extends Service>, Object> getProvidedServices() {
        return this.providedServices;
    }

    public void addProvidedService(Class<? extends Service> serviceRole, Object service) {
        this.providedServices.put(serviceRole, service);
    }

    public boolean isTransactionManagerExpected() {
        return this.transactionsExpected;
    }

    public void setTransactionsExpected(boolean transactionsExpected) {
        this.transactionsExpected = transactionsExpected;
    }

    public InstanceInitializer getInstanceInitializer() {
        return this.initializer;
    }

    public boolean isIndexMetadataComplete() {
        return this.indexMetadataComplete;
    }

    public void setIndexMetadataComplete(boolean indexMetadataComplete) {
        this.indexMetadataComplete = indexMetadataComplete;
    }

    public void setDeleteByTermEnforced(boolean deleteByTermEnforced) {
        this.deleteByTermEnforced = deleteByTermEnforced;
    }

    public boolean isDeleteByTermEnforced() {
        return this.deleteByTermEnforced;
    }

    public boolean isIdProvidedImplicit() {
        return this.idProvidedImplicit;
    }

    public SearchConfigurationForTest setIdProvidedImplicit(boolean idProvidedImplicit) {
        this.idProvidedImplicit = idProvidedImplicit;
        return this;
    }

    public boolean isMultitenancyEnabled() {
        return this.multitenancyEnabled;
    }

    public SearchConfigurationForTest setMultitenancyEnabled(boolean multitenancyEnabled) {
        this.multitenancyEnabled = multitenancyEnabled;
        return this;
    }

    public ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }

    public void setClassLoaderService(ClassLoaderService classLoaderService) {
        this.classLoaderService = classLoaderService;
    }
}

