/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.analyzerdef;

import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.fest.assertions.Assertions;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.spi.impl.SearchFactoryState;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AnalyzerDefAnnotationTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(Sample.class);

    @Test
    public void shouldBePossibleToAnnotatePackage() throws Exception {
        this.assertAnalyzerExists("package-analyzer");
    }

    @Test
    public void shouldBePossibleToAnnotateClass() throws Exception {
        this.assertAnalyzerExists("class-analyzer");
    }

    @Test
    public void shouldContainOnlyTheDefinedAnalyzers() throws Exception {
        Map analyzerReferences = ((SearchFactoryState)this.sfHolder.getSearchFactory()).getAnalyzerReferences();
        Assertions.assertThat(analyzerReferences.keySet()).containsOnly(new Object[]{"package-analyzer", "class-analyzer"});
    }

    @Test
    public void shouldNotBePossibleToHaveTwoAnalyzerDefsWithTheSameName() throws Exception {
        this.thrown.expect(SearchException.class);
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(SampleWithError.class);
        new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator().close();
    }

    private void assertAnalyzerExists(String analyzerName) {
        Analyzer analyzer = this.sfHolder.getSearchFactory().getAnalyzer(analyzerName);
        Assertions.assertThat((Object)analyzer).isNotNull();
    }

    @Indexed
    @AnalyzerDef(name="package-analyzer", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class))
    static class SampleWithError {
        @DocumentId
        final long id = 1L;
        @Field
        final String description = "";

        SampleWithError() {
        }
    }

    @Indexed
    @AnalyzerDef(name="class-analyzer", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class))
    static class Sample {
        @DocumentId
        long id;
        @Field
        String description;

        Sample() {
        }
    }
}

