/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.lucene;

import java.io.Serializable;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.test.backend.lucene.Quote;
import org.hibernate.search.testsupport.BytemanHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.CountingErrorHandler;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMRules;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
@BMRules(rules={@BMRule(name="trackIndexWriterCommit", targetClass="org.apache.lucene.index.IndexWriter", targetMethod="commit()", helper="org.hibernate.search.testsupport.BytemanHelper", action="pushEvent(\"commit\")"), @BMRule(name="trackIndexWriterClose", targetClass="org.apache.lucene.index.IndexWriter", targetMethod="close()", helper="org.hibernate.search.testsupport.BytemanHelper", action="pushEvent(\"close\")"), @BMRule(name="trackUpdatesBeingApplied", targetClass="org.hibernate.search.backend.impl.lucene.LuceneBackendQueueTask", targetMethod="applyUpdates()", helper="org.hibernate.search.testsupport.BytemanHelper", action="pushEvent(\"applyUpdates\")")})
@Category(value={SkipOnElasticsearch.class})
public class ResourcesClosedInOrderTest {
    private static final int NUMBER_ENTITIES = 2;
    @Rule
    public BytemanHelper.BytemanAccessor byteman = BytemanHelper.createAccessor();

    @Test
    public void asyncExclusiveIndexResourcesOrderedShutdown() {
        this.expectOnConfiguration(true, true, "close", "applyUpdates", "applyUpdates", "close");
    }

    @Test
    public void asyncSharedIndexResourcesOrderedShutdown() {
        this.expectOnConfiguration(true, false, "close", "applyUpdates", "close", "applyUpdates", "close");
    }

    @Test
    public void synchExclusiveIndexResourcesOrderedShutdown() {
        this.expectOnConfiguration(false, true, "close", "applyUpdates", "commit", "applyUpdates", "commit", "close");
    }

    @Test
    public void synchSharedIndexResourcesOrderedShutdown() {
        this.expectOnConfiguration(false, false, "close", "applyUpdates", "close", "applyUpdates", "close");
    }

    private void expectOnConfiguration(boolean async, boolean exclusiveIndexing, String ... expectedStack) {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addProperty("hibernate.search.default.worker.execution", async ? "async" : "sync");
        cfg.addProperty("hibernate.search.default.exclusive_index_use", exclusiveIndexing ? "true" : "false");
        cfg.addProperty("hibernate.search.error_handler", CountingErrorHandler.class.getName());
        cfg.addClass(Quote.class);
        try (SearchIntegrator searchIntegrator = new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator();){
            CountingErrorHandler errorHandler = (CountingErrorHandler)searchIntegrator.getErrorHandler();
            this.writeData(searchIntegrator, 2);
            Assert.assertEquals((long)0L, (long)errorHandler.getTotalCount());
        }
        for (int i = 0; i < expectedStack.length; ++i) {
            Assert.assertEquals((Object)expectedStack[i], (Object)this.byteman.consumeNextRecordedEvent());
        }
        Assert.assertTrue((boolean)this.byteman.isEventStackEmpty());
    }

    private void writeData(SearchIntegrator searchIntegrator, int numberEntities) {
        int entityIdGenerator = 0;
        for (int i = 0; i < numberEntities; ++i) {
            Integer id = entityIdGenerator++;
            Quote quote = new Quote(id, "description");
            Work work = new Work((Object)quote, (Serializable)id, WorkType.ADD, false);
            TransactionContextForTest tc = new TransactionContextForTest();
            searchIntegrator.getWorker().performWork(work, (TransactionContext)tc);
            tc.end();
        }
    }
}

