/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.analyzerdefinitionprovider;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.pattern.PatternReplaceCharFilterFactory;
import org.apache.lucene.analysis.pattern.PatternTokenizerFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.fest.assertions.ObjectAssert;
import org.hibernate.search.analyzer.definition.LuceneAnalyzerDefinitionRegistryBuilder;
import org.hibernate.search.analyzer.definition.spi.LuceneAnalyzerDefinitionProvider;
import org.hibernate.search.analyzer.definition.spi.LuceneAnalyzerDefinitionSourceService;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={SkipOnElasticsearch.class})
@TestForIssue(jiraKey="HSEARCH-2418")
public class LuceneAnalyzerDefinitionProviderTest {
    private static final String CUSTOM_ANALYZER_NAME = "custom-analyzer";
    private static final String CUSTOM_ANALYZER_2_NAME = "custom-analyzer-2";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void simple() {
        ExtendedSearchIntegrator integrator = this.init(CustomAnalyzerProvider.class, CustomAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzer(CUSTOM_ANALYZER_NAME)).as("Analyzer for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzerRegistry((IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE).getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
        CustomAnalyzerEntity entity = new CustomAnalyzerEntity();
        entity.id = 0L;
        entity.field = "charFilterShouldReplace|foo";
        this.index((SearchIntegrator)integrator, entity);
        this.assertMatchesExactly((SearchIntegrator)integrator, entity, "field", "charfilterdidreplace");
    }

    @Test
    public void usingServiceOverride() {
        ExtendedSearchIntegrator integrator = this.initUsingService(new CustomAnalyzerProvider(), CustomAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzer(CUSTOM_ANALYZER_NAME)).as("Analyzer for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzerRegistry((IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE).getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
        CustomAnalyzerEntity entity = new CustomAnalyzerEntity();
        entity.id = 0L;
        entity.field = "charFilterShouldReplace|foo";
        this.index((SearchIntegrator)integrator, entity);
        this.assertMatchesExactly((SearchIntegrator)integrator, entity, "field", "charfilterdidreplace");
    }

    @Test
    public void override() {
        ExtendedSearchIntegrator integrator = this.init(CustomAnalyzerProvider.class, AnalyzerDefAnnotationEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzer(CUSTOM_ANALYZER_NAME)).as("Analyzer for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzerRegistry((IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE).getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
        AnalyzerDefAnnotationEntity entity = new AnalyzerDefAnnotationEntity();
        entity.id = 0L;
        entity.field = "charFilterShouldReplace|foo";
        this.index((SearchIntegrator)integrator, entity);
        this.assertMatchesExactly((SearchIntegrator)integrator, entity, "field", "charFilterShouldReplace|foo");
    }

    @Test
    public void unreferencedAnalyzer() {
        ExtendedSearchIntegrator integrator = this.init(CustomAnalyzerProvider.class, NoAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzer(CUSTOM_ANALYZER_NAME)).as("Analyzer for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzerRegistry((IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE).getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
    }

    @Test
    public void instantiation_factorymethod() {
        ExtendedSearchIntegrator integrator = this.init(ProviderFactory.class, CustomAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzer(CUSTOM_ANALYZER_NAME)).as("Analyzer for 'custom-analyzer' fetched from the integrator")).isNotNull();
    }

    @Test
    public void invalid() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(CustomAnalyzerEntity.class);
        cfg.addProperty("hibernate.search.lucene.analyzer_definition_provider", "invalidValue");
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000329");
        new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator();
    }

    @Test
    public void namingConflict_withinProvider() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000330");
        this.init(ProviderWithInternalNamingConflict.class, CustomAnalyzerEntity.class);
    }

    private ExtendedSearchIntegrator initUsingService(final LuceneAnalyzerDefinitionProvider analyzerProvider, Class<?> ... entityClasses) {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        for (Class<?> entityClass : entityClasses) {
            cfg.addClass(entityClass);
        }
        cfg.getProvidedServices().put(LuceneAnalyzerDefinitionSourceService.class, new LuceneAnalyzerDefinitionSourceService(){

            public LuceneAnalyzerDefinitionProvider getLuceneAnalyzerDefinitionProvider() {
                return analyzerProvider;
            }
        });
        return (ExtendedSearchIntegrator)new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator().unwrap(ExtendedSearchIntegrator.class);
    }

    private ExtendedSearchIntegrator init(Class<?> providerClass, Class<?> ... entityClasses) {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        for (Class<?> entityClass : entityClasses) {
            cfg.addClass(entityClass);
        }
        cfg.addProperty("hibernate.search.lucene.analyzer_definition_provider", providerClass.getName());
        return (ExtendedSearchIntegrator)new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator().unwrap(ExtendedSearchIntegrator.class);
    }

    private void index(SearchIntegrator integrator, Identifiable entity) {
        Work work = new Work((Object)entity, (Serializable)Long.valueOf(entity.getId()), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        integrator.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    private void assertMatchesExactly(SearchIntegrator integrator, Identifiable entity, String fieldName, String termValue) {
        this.assertMatchesExactly(integrator, entity, (Query)new TermQuery(new Term(fieldName, termValue)));
    }

    private void assertMatchesExactly(SearchIntegrator integrator, Identifiable entity, Query luceneQuery) {
        Class<?> entityClass = entity.getClass();
        HSQuery query = integrator.createHSQuery(luceneQuery, new Class[]{entityClass});
        List results = query.queryEntityInfos();
        ((ListAssert)Assertions.assertThat((List)results).onProperty("id").as("Results of query '" + luceneQuery + "' on " + entityClass.getSimpleName())).containsExactly(new Object[]{entity.getId()});
    }

    public static class ProviderWithInternalNamingConflict
    implements LuceneAnalyzerDefinitionProvider {
        public void register(LuceneAnalyzerDefinitionRegistryBuilder builder) {
            builder.analyzer(LuceneAnalyzerDefinitionProviderTest.CUSTOM_ANALYZER_NAME).tokenizer(StandardTokenizerFactory.class).analyzer(LuceneAnalyzerDefinitionProviderTest.CUSTOM_ANALYZER_NAME).tokenizer(StandardTokenizerFactory.class);
        }
    }

    public static class CustomAnalyzer2Provider
    implements LuceneAnalyzerDefinitionProvider {
        public void register(LuceneAnalyzerDefinitionRegistryBuilder builder) {
            builder.analyzer(LuceneAnalyzerDefinitionProviderTest.CUSTOM_ANALYZER_2_NAME).tokenizer(WhitespaceTokenizerFactory.class);
        }
    }

    public static class ProviderFactory {
        @Factory
        public static CustomAnalyzerProvider create() {
            return new CustomAnalyzerProvider();
        }
    }

    public static class CustomAnalyzerProvider
    implements LuceneAnalyzerDefinitionProvider {
        public void register(LuceneAnalyzerDefinitionRegistryBuilder builder) {
            builder.analyzer(LuceneAnalyzerDefinitionProviderTest.CUSTOM_ANALYZER_NAME).tokenizer(PatternTokenizerFactory.class).param("pattern", "\\|").charFilter(PatternReplaceCharFilterFactory.class).param("pattern", "charFilterShouldReplace").param("replacement", "charFilterDidReplace").tokenFilter(LowerCaseFilterFactory.class);
        }
    }

    @Indexed
    static class CustomAnalyzer2Entity
    implements Identifiable {
        @DocumentId
        long id;
        @Field(analyzer=@Analyzer(definition="custom-analyzer-2"))
        String field;

        CustomAnalyzer2Entity() {
        }

        @Override
        public long getId() {
            return this.id;
        }
    }

    @Indexed
    @AnalyzerDef(name="custom-analyzer", tokenizer=@TokenizerDef(factory=KeywordTokenizerFactory.class))
    static class AnalyzerDefAnnotationEntity
    extends CustomAnalyzerEntity {
        AnalyzerDefAnnotationEntity() {
        }
    }

    @Indexed
    static class CustomAnalyzerEntity
    implements Identifiable {
        @DocumentId
        long id;
        @Field(analyzer=@Analyzer(definition="custom-analyzer"))
        String field;

        CustomAnalyzerEntity() {
        }

        @Override
        public long getId() {
            return this.id;
        }
    }

    @Indexed
    static class NoAnalyzerEntity
    implements Identifiable {
        @DocumentId
        long id;
        @Field(analyze=Analyze.NO)
        String field;

        NoAnalyzerEntity() {
        }

        @Override
        public long getId() {
            return this.id;
        }
    }

    private static interface Identifiable {
        public long getId();
    }
}

