/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.fest.assertions.ObjectArrayAssert;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2531")
public class IndexNameOverrideTest {
    public static final String INDEXED_ANNOTATION_OVERRIDDEN_INDEX_NAME = "indexed_annotation_overridden_index_name";
    public static final String CONFIGURATION_OVERRIDDEN_INDEX_NAME = "configuration_overridden_index_name";

    @Test
    public void noOverride() throws Exception {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(NoAnnotationIndexNameOverrideEntity.class);
        try (SearchIntegrator integrator = this.init(cfg);){
            ((ObjectArrayAssert)Assertions.assertThat((Object[])integrator.getIndexBinding(NoAnnotationIndexNameOverrideEntity.class).getIndexManagers()).onProperty("indexName").as("Index names for entity " + NoAnnotationIndexNameOverrideEntity.class)).containsOnly(new Object[]{NoAnnotationIndexNameOverrideEntity.class.getName()});
            NoAnnotationIndexNameOverrideEntity entity = new NoAnnotationIndexNameOverrideEntity();
            entity.id = 1L;
            this.assertIndexingWorksProperly(integrator, entity, Long.valueOf(entity.id));
        }
    }

    @Test
    public void annotationOverride() throws Exception {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(IndexedAnnotationIndexNameOverriddeEntity.class);
        try (SearchIntegrator integrator = this.init(cfg);){
            ((ObjectArrayAssert)Assertions.assertThat((Object[])integrator.getIndexBinding(IndexedAnnotationIndexNameOverriddeEntity.class).getIndexManagers()).onProperty("indexName").as("Index names for entity " + IndexedAnnotationIndexNameOverriddeEntity.class)).containsOnly(new Object[]{INDEXED_ANNOTATION_OVERRIDDEN_INDEX_NAME});
            IndexedAnnotationIndexNameOverriddeEntity entity = new IndexedAnnotationIndexNameOverriddeEntity();
            entity.id = 1L;
            this.assertIndexingWorksProperly(integrator, entity, Long.valueOf(entity.id));
        }
    }

    @Test
    public void configurationOverride() throws Exception {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(NoAnnotationIndexNameOverrideEntity.class);
        cfg.addProperty("hibernate.search." + NoAnnotationIndexNameOverrideEntity.class.getName() + "." + "indexName", CONFIGURATION_OVERRIDDEN_INDEX_NAME);
        try (SearchIntegrator integrator = this.init(cfg);){
            ((ObjectArrayAssert)Assertions.assertThat((Object[])integrator.getIndexBinding(NoAnnotationIndexNameOverrideEntity.class).getIndexManagers()).onProperty("indexName").as("Index names for entity " + NoAnnotationIndexNameOverrideEntity.class)).containsOnly(new Object[]{NoAnnotationIndexNameOverrideEntity.class.getName()});
            NoAnnotationIndexNameOverrideEntity entity = new NoAnnotationIndexNameOverrideEntity();
            entity.id = 1L;
            this.assertIndexingWorksProperly(integrator, entity, Long.valueOf(entity.id));
        }
    }

    @Test
    public void configurationAndAnnotationOverride() throws Exception {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(IndexedAnnotationIndexNameOverriddeEntity.class);
        cfg.addProperty("hibernate.search." + IndexedAnnotationIndexNameOverriddeEntity.class.getName() + "." + "indexName", CONFIGURATION_OVERRIDDEN_INDEX_NAME);
        try (SearchIntegrator integrator = this.init(cfg);){
            ((ObjectArrayAssert)Assertions.assertThat((Object[])integrator.getIndexBinding(IndexedAnnotationIndexNameOverriddeEntity.class).getIndexManagers()).onProperty("indexName").as("Index names for entity " + IndexedAnnotationIndexNameOverriddeEntity.class)).containsOnly(new Object[]{INDEXED_ANNOTATION_OVERRIDDEN_INDEX_NAME});
            IndexedAnnotationIndexNameOverriddeEntity entity = new IndexedAnnotationIndexNameOverriddeEntity();
            entity.id = 1L;
            this.assertIndexingWorksProperly(integrator, entity, Long.valueOf(entity.id));
        }
    }

    private SearchIntegrator init(SearchConfigurationForTest cfg) {
        return new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator();
    }

    private void assertIndexingWorksProperly(SearchIntegrator integrator, Object entity, Serializable id) {
        this.storeData(integrator, entity, id);
        HSQuery query = integrator.createHSQuery((Query)new MatchAllDocsQuery(), new Class[]{entity.getClass()});
        List result = query.queryEntityInfos();
        ((ListAssert)Assertions.assertThat((List)result).onProperty("id").as("Indexed entities IDs")).containsOnly(new Object[]{id});
    }

    private void storeData(SearchIntegrator integrator, Object entity, Serializable id) {
        Work work = new Work(entity, id, WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        integrator.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    @Indexed
    public static final class NoAnnotationIndexNameOverrideEntity {
        @DocumentId
        private long id;
        @Field
        private String field;
    }

    @Indexed(index="indexed_annotation_overridden_index_name")
    public static final class IndexedAnnotationIndexNameOverriddeEntity {
        @DocumentId
        private long id;
        @Field
        private String field;
    }
}

