/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.Map;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;

public class MultiFieldMapBridge
implements MetadataProvidingFieldBridge {
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("This field can only be applied on a Map type field");
        }
        Map userValue = (Map)value;
        for (Map.Entry e : userValue.entrySet()) {
            this.setField(name, String.valueOf(e.getKey()), String.valueOf(e.getValue()), document, luceneOptions);
        }
    }

    private void setField(String fieldPrefix, String key, String value, Document document, LuceneOptions luceneOptions) {
        luceneOptions.addFieldToDocument(fieldPrefix + "." + key, value, document);
    }

    public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
        builder.field(name, FieldType.OBJECT);
    }
}

