/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan.sharedIndex;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.infinispan.InfinispanDirectoryProvider;
import org.hibernate.search.infinispan.sharedIndex.Device;
import org.hibernate.search.infinispan.sharedIndex.Robot;
import org.hibernate.search.infinispan.sharedIndex.Toaster;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SharedIndexTest {
    FullTextSessionBuilder node;

    @Test
    public void testSingleResultFromDeviceIndex() {
        Assert.assertEquals((long)1L, (long)this.clusterSize(this.node, Toaster.class));
        FullTextSession fullTextSession = this.node.openFullTextSession();
        Transaction transaction = fullTextSession.beginTransaction();
        Toaster toaster = new Toaster("A1");
        fullTextSession.save((Object)toaster);
        transaction.commit();
        fullTextSession.close();
        this.verifyResult(this.node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyResult(FullTextSessionBuilder node) {
        FullTextSession fullTextSession = node.openFullTextSession();
        try {
            Transaction transaction = fullTextSession.beginTransaction();
            QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Toaster.class).get();
            Query query = queryBuilder.keyword().onField("serialNumber").matching((Object)"A1").createQuery();
            List list = fullTextSession.createFullTextQuery(query, new Class[0]).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Device device = (Device)list.get(0);
            Assert.assertEquals((Object)"GE", (Object)device.manufacturer);
            transaction.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    @Before
    public void setUp() throws Exception {
        HashSet annotatedTypes = new HashSet();
        annotatedTypes.add(Device.class);
        annotatedTypes.add(Robot.class);
        annotatedTypes.add(Toaster.class);
        this.node = new FullTextSessionBuilder();
        this.prepareCommonConfiguration(this.node, annotatedTypes);
        this.node.build();
        this.waitMembersCount(this.node, Toaster.class, 1);
    }

    @After
    public void tearDown() throws Exception {
        this.node.close();
    }

    protected void prepareCommonConfiguration(FullTextSessionBuilder cfg, Set<Class<?>> entityTypes) {
        cfg.setProperty("hibernate.search.default.directory_provider", "infinispan");
        cfg.setProperty("hibernate.search.infinispan.configuration_resourcename", "testing-hibernatesearch-infinispan.xml");
        for (Class<?> type : entityTypes) {
            cfg.addAnnotatedClass(type);
        }
    }

    protected void waitMembersCount(FullTextSessionBuilder node, Class<?> entityType, int expectedSize) throws InterruptedException {
        int currentSize = 0;
        int loopCounter = 0;
        while (currentSize < expectedSize) {
            Thread.sleep(10L);
            currentSize = this.clusterSize(node, entityType);
            if (loopCounter <= 200) continue;
            throw new AssertionFailedError("timeout while waiting for all nodes to join in cluster");
        }
    }

    protected int clusterSize(FullTextSessionBuilder node, Class<?> entityType) {
        SearchFactory searchFactory = node.getSearchFactory();
        DirectoryProvider[] directoryProviders = searchFactory.getDirectoryProviders(entityType);
        Assert.assertEquals((long)1L, (long)directoryProviders.length);
        InfinispanDirectoryProvider directoryProvider = (InfinispanDirectoryProvider)directoryProviders[0];
        EmbeddedCacheManager cacheManager = directoryProvider.getCacheManager();
        List members = cacheManager.getMembers();
        return members.size();
    }
}

