/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan;

import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.store.Directory;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;
import org.hibernate.search.infinispan.CacheManagerServiceProvider;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.DirectoryProviderHelper;
import org.hibernate.search.util.LoggerFactory;
import org.infinispan.Cache;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.slf4j.Logger;

public class InfinispanDirectoryProvider
implements DirectoryProvider<InfinispanDirectory> {
    private static final Logger log = LoggerFactory.make();
    public static final String DEFAULT_LOCKING_CACHENAME = "LuceneIndexesLocking";
    public static final String DEFAULT_INDEXESDATA_CACHENAME = "LuceneIndexesData";
    public static final String DEFAULT_INDEXESMETADATA_CACHENAME = "LuceneIndexesMetadata";
    private BuildContext context;
    private String directoryProviderName;
    private String metadataCacheName;
    private String dataCacheName;
    private String lockingCacheName;
    private int chunkSize;
    private InfinispanDirectory directory;
    private EmbeddedCacheManager cacheManager;

    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        this.directoryProviderName = directoryProviderName;
        this.context = context;
        this.metadataCacheName = properties.getProperty("metadata_cachename", DEFAULT_INDEXESMETADATA_CACHENAME);
        this.dataCacheName = properties.getProperty("data_cachename", DEFAULT_INDEXESDATA_CACHENAME);
        this.lockingCacheName = properties.getProperty("locking_cachename", DEFAULT_LOCKING_CACHENAME);
        this.chunkSize = ConfigurationParseHelper.getIntValue((Properties)properties, (String)"chunk_size", (int)16384);
    }

    public void start() {
        log.debug("Starting InfinispanDirectory");
        this.cacheManager = (EmbeddedCacheManager)this.context.requestService(CacheManagerServiceProvider.class);
        Cache metadataCache = this.cacheManager.getCache(this.metadataCacheName);
        Cache dataCache = this.cacheManager.getCache(this.dataCacheName);
        Cache lockingCache = this.cacheManager.getCache(this.lockingCacheName);
        this.directory = new InfinispanDirectory(metadataCache, dataCache, lockingCache, this.directoryProviderName, this.chunkSize);
        DirectoryProviderHelper.initializeIndexIfNeeded((Directory)this.directory);
        log.debug("Initialized Infinispan index: '{}'", (Object)this.directoryProviderName);
    }

    public void stop() {
        try {
            this.directory.close();
        }
        catch (IOException e) {
            throw new SearchException((Throwable)e);
        }
        finally {
            this.context.releaseService(CacheManagerServiceProvider.class);
        }
        log.debug("Stopped InfinispanDirectory");
    }

    public InfinispanDirectory getDirectory() {
        return this.directory;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof InfinispanDirectoryProvider)) {
            return false;
        }
        return this.directoryProviderName.equals(((InfinispanDirectoryProvider)obj).directoryProviderName);
    }

    public int hashCode() {
        int hash = 11;
        return 37 * hash + this.directoryProviderName.hashCode();
    }
}

