/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.util.Digest;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class JoinRsp
implements Streamable {
    private View view = null;
    private Digest digest = null;
    private String fail_reason = null;
    protected static final byte VIEW_PRESENT = 1;
    protected static final byte DIGEST_PRESENT = 2;
    protected static final byte FAIL_REASON_PRESENT = 4;

    public JoinRsp() {
    }

    public JoinRsp(View v, Digest d) {
        this.view = v;
        this.digest = d;
    }

    public JoinRsp(String fail_reason) {
        this.fail_reason = fail_reason;
    }

    public View getView() {
        return this.view;
    }

    public Digest getDigest() {
        return this.digest;
    }

    public String getFailReason() {
        return this.fail_reason;
    }

    public void setFailReason(String r) {
        this.fail_reason = r;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        byte flags = 0;
        if (this.view != null) {
            flags = (byte)(flags | 1);
        }
        if (this.digest != null) {
            flags = (byte)(flags | 2);
        }
        if (this.fail_reason != null) {
            flags = (byte)(flags | 4);
        }
        out.writeByte(flags);
        int size = 0;
        if (this.view != null) {
            this.view.getViewId().writeTo(out);
            size = this.view.size();
            out.writeShort(size);
            for (Address mbr : this.view) {
                Util.writeAddress(mbr, out);
            }
        }
        if (this.digest != null && this.view != null) {
            for (Address mbr : this.view) {
                long[] seqnos = this.digest.get(mbr);
                if (seqnos == null) {
                    seqnos = new long[]{-1L, -1L};
                }
                Util.writeLongSequence(seqnos[0], seqnos[1], out);
            }
        }
        if (this.fail_reason != null) {
            out.writeUTF(this.fail_reason);
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        Address mbr;
        int i;
        byte flags = in.readByte();
        int size = 0;
        ArrayList<Address> members = null;
        if ((flags & 1) == 1) {
            ViewId vid = new ViewId();
            vid.readFrom(in);
            size = in.readShort();
            members = new ArrayList<Address>(size);
            for (i = 0; i < size; ++i) {
                mbr = Util.readAddress(in);
                members.add(mbr);
            }
            this.view = new View(vid, members);
        }
        if (members != null && (flags & 2) == 2) {
            MutableDigest tmp = new MutableDigest(size);
            for (i = 0; i < size; ++i) {
                mbr = (Address)members.get(i);
                long[] seqnos = Util.readLongSequence(in);
                if (seqnos[0] == -1L && seqnos[1] == -1L) continue;
                tmp.add(mbr, seqnos[0], seqnos[1], false);
            }
            this.digest = tmp;
        }
        if ((flags & 4) == 4) {
            this.fail_reason = in.readUTF();
        }
    }

    public int serializedSize() {
        int retval = 1;
        if (this.view != null) {
            retval += this.view.getVid().serializedSize();
            retval += 2;
            for (Address mbr : this.view) {
                retval += Util.size(mbr);
            }
        }
        if (this.digest != null) {
            for (Digest.DigestEntry entry : this.digest) {
                retval += Util.size(entry.getHighestDeliveredSeqno(), entry.getHighestReceivedSeqno());
            }
        }
        if (this.fail_reason != null) {
            retval += this.fail_reason.length() + 2;
        }
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("view: ");
        if (this.view == null) {
            sb.append("<null>");
        } else {
            sb.append(this.view);
        }
        sb.append(", digest: ");
        if (this.digest == null) {
            sb.append("<null>");
        } else {
            sb.append(this.digest);
        }
        if (this.fail_reason != null) {
            sb.append(", fail reason: ").append(this.fail_reason);
        }
        return sb.toString();
    }
}

