/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.engine.spi.DepthValidator;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.interceptor.IndexingOverride;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class WorkPlan {
    private static final Log log = LoggerFactory.make();
    private final HashMap<Class<?>, PerClassWork<?>> byClass = new HashMap();
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final InstanceInitializer instanceInitializer;
    private int approximateWorkQueueSize = 0;

    public WorkPlan(SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.instanceInitializer = searchFactoryImplementor.getInstanceInitializer();
    }

    public <T> void addWork(Work<T> work) {
        ++this.approximateWorkQueueSize;
        Class<T> entityClass = this.instanceInitializer.getClassFromWork(work);
        PerClassWork classWork = this.getClassWork(entityClass);
        classWork.addWork(work);
    }

    public void clear() {
        this.byClass.clear();
        this.approximateWorkQueueSize = 0;
    }

    public int size() {
        return this.approximateWorkQueueSize;
    }

    private <T> PerClassWork getClassWork(Class<T> entityClass) {
        PerClassWork<Object> classWork = this.byClass.get(entityClass);
        if (classWork == null) {
            classWork = new PerClassWork<T>(entityClass);
            this.byClass.put(entityClass, classWork);
        }
        return classWork;
    }

    public void processContainedInAndPrepareExecution() {
        PerClassWork[] worksFromEvents = new PerClassWork[this.byClass.size()];
        for (PerClassWork perClassWork : worksFromEvents = this.byClass.values().toArray(worksFromEvents)) {
            perClassWork.processContainedInAndPrepareExecution();
        }
    }

    public <T> void recurseContainedIn(T value, DepthValidator depth) {
        Class<T> entityClass = this.instanceInitializer.getClass(value);
        PerClassWork classWork = this.getClassWork(entityClass);
        classWork.recurseContainedIn(value, depth);
    }

    public List<LuceneWork> getPlannedLuceneWork() {
        ArrayList<LuceneWork> luceneQueue = new ArrayList<LuceneWork>();
        for (PerClassWork<?> perClassWork : this.byClass.values()) {
            perClassWork.enqueueLuceneWork(luceneQueue);
        }
        return luceneQueue;
    }

    private static <T> AbstractDocumentBuilder<T> getEntityBuilder(SearchFactoryImplementor searchFactoryImplementor, Class<?> entityClass) {
        EntityIndexBinding entityIndexBinding = searchFactoryImplementor.getIndexBinding(entityClass);
        if (entityIndexBinding == null) {
            DocumentBuilderContainedEntity<?> entityBuilder = searchFactoryImplementor.getDocumentBuilderContainedEntity(entityClass);
            if (entityBuilder == null) {
                throw new SearchException("Unable to perform work. Entity Class is not @Indexed nor hosts @ContainedIn: " + entityClass);
            }
            return entityBuilder;
        }
        return entityIndexBinding.getDocumentBuilder();
    }

    private static class PerEntityWork<T> {
        private T entity;
        private boolean delete = false;
        private boolean add = false;
        private boolean containedInProcessed = false;

        private PerEntityWork(T entity) {
            this.entity = entity;
            this.delete = true;
            this.add = true;
            this.containedInProcessed = true;
        }

        private PerEntityWork(Work<T> work) {
            this.entity = work.getEntity();
            WorkType type = work.getType();
            switch (type) {
                case ADD: {
                    this.add = true;
                    break;
                }
                case DELETE: 
                case PURGE: {
                    this.delete = true;
                    break;
                }
                case COLLECTION: 
                case UPDATE: {
                    this.delete = true;
                    this.add = true;
                    break;
                }
                case INDEX: {
                    this.add = true;
                    this.delete = true;
                    break;
                }
                default: {
                    throw new SearchException("unexpected state:" + (Object)((Object)type));
                }
            }
        }

        public void addWork(Work<T> work) {
            this.entity = work.getEntity();
            WorkType type = work.getType();
            switch (type) {
                case UPDATE: 
                case INDEX: {
                    if (this.add && !this.delete) break;
                    this.add = true;
                    this.delete = true;
                    break;
                }
                case ADD: {
                    this.add = true;
                    break;
                }
                case DELETE: 
                case PURGE: {
                    if (this.add && !this.delete) {
                        this.add = false;
                        break;
                    }
                    this.add = false;
                    this.delete = true;
                    break;
                }
                case COLLECTION: {
                    if (this.add || this.delete) break;
                    this.add = true;
                    this.delete = true;
                    break;
                }
                default: {
                    throw new SearchException("unexpected state:" + (Object)((Object)type));
                }
            }
        }

        public void enqueueLuceneWork(Class<T> entityClass, Serializable indexingId, AbstractDocumentBuilder<T> entityBuilder, List<LuceneWork> luceneQueue, ConversionContext conversionContext) {
            if (this.add || this.delete) {
                entityBuilder.addWorkToQueue(entityClass, this.entity, indexingId, this.delete, this.add, luceneQueue, conversionContext);
            }
        }

        public void processContainedIn(AbstractDocumentBuilder<T> entityBuilder, WorkPlan workplan) {
            if (!this.containedInProcessed) {
                this.containedInProcessed = true;
                if (this.add || this.delete) {
                    entityBuilder.appendContainedInWorkForInstance(this.entity, workplan, null);
                }
            }
        }
    }

    class PerClassWork<T> {
        private final HashMap<Serializable, PerEntityWork<T>> entityById = new HashMap();
        private boolean purgeAll = false;
        private final Class<T> entityClass;
        private final AbstractDocumentBuilder<T> documentBuilder;
        private final boolean containedInOnly;

        PerClassWork(Class<T> clazz) {
            this.entityClass = clazz;
            this.documentBuilder = WorkPlan.getEntityBuilder(WorkPlan.this.searchFactoryImplementor, clazz);
            this.containedInOnly = this.documentBuilder instanceof DocumentBuilderContainedEntity;
        }

        public void addWork(Work<T> work) {
            if (work.getType() == WorkType.PURGE_ALL) {
                this.entityById.clear();
                this.purgeAll = true;
            } else {
                Serializable id = this.extractProperId(work);
                PerEntityWork<T> entityWork = this.entityById.get(id);
                if (entityWork == null) {
                    entityWork = new PerEntityWork(work);
                    this.entityById.put(id, entityWork);
                }
                entityWork.addWork(work);
            }
        }

        private Serializable extractProperId(Work<T> work) {
            if (this.containedInOnly) {
                return work.getId();
            }
            T entity = work.getEntity();
            if (entity == null || this.documentBuilder.requiresProvidedId() || work.isIdentifierWasRolledBack() && this.documentBuilder.isIdMatchingJpaId()) {
                return work.getId();
            }
            return this.documentBuilder.getId(entity);
        }

        public void enqueueLuceneWork(List<LuceneWork> luceneQueue) {
            Set<Map.Entry<Serializable, PerEntityWork<T>>> entityInstances = this.entityById.entrySet();
            ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
            if (this.purgeAll) {
                luceneQueue.add(new PurgeAllLuceneWork(this.entityClass));
            }
            for (Map.Entry<Serializable, PerEntityWork<T>> entry : entityInstances) {
                Serializable indexingId = entry.getKey();
                PerEntityWork<T> perEntityWork = entry.getValue();
                perEntityWork.enqueueLuceneWork(this.entityClass, indexingId, this.documentBuilder, luceneQueue, conversionContext);
            }
        }

        public void processContainedInAndPrepareExecution() {
            Map.Entry[] entityInstancesFrozenView = new Map.Entry[this.entityById.size()];
            for (Map.Entry entry : entityInstancesFrozenView = this.entityById.entrySet().toArray(entityInstancesFrozenView)) {
                PerEntityWork perEntityWork = (PerEntityWork)entry.getValue();
                perEntityWork.processContainedIn(this.documentBuilder, WorkPlan.this);
            }
        }

        void recurseContainedIn(T value, DepthValidator depth) {
            if (this.documentBuilder.requiresProvidedId()) {
                log.containedInPointsToProvidedId(WorkPlan.this.instanceInitializer.getClass(value));
            } else {
                Serializable extractedId = this.documentBuilder.getId(value);
                if (extractedId != null) {
                    PerEntityWork<T> entityWork = this.entityById.get(extractedId);
                    if (entityWork == null) {
                        EntityIndexingInterceptor<T> entityInterceptor = this.getEntityInterceptor();
                        IndexingOverride operation = entityInterceptor != null ? entityInterceptor.onUpdate(value) : IndexingOverride.APPLY_DEFAULT;
                        switch (operation) {
                            case UPDATE: 
                            case APPLY_DEFAULT: {
                                entityWork = new PerEntityWork(value);
                                this.entityById.put(extractedId, entityWork);
                                break;
                            }
                            case SKIP: {
                                log.forceSkipIndexOperationViaInterception(this.entityClass, WorkType.UPDATE);
                                break;
                            }
                            case REMOVE: {
                                log.forceRemoveOnIndexOperationViaInterception(this.entityClass, WorkType.UPDATE);
                                Work<T> work = new Work<T>(value, extractedId, WorkType.DELETE);
                                entityWork = new PerEntityWork(work);
                                this.entityById.put(extractedId, entityWork);
                                break;
                            }
                            default: {
                                throw new AssertionFailure("Unknown action type: " + (Object)((Object)operation));
                            }
                        }
                        this.documentBuilder.appendContainedInWorkForInstance(value, WorkPlan.this, depth);
                    }
                } else {
                    this.documentBuilder.appendContainedInWorkForInstance(value, WorkPlan.this, depth);
                }
            }
        }

        private EntityIndexingInterceptor<? super T> getEntityInterceptor() {
            EntityIndexBinding indexBindingForEntity = WorkPlan.this.searchFactoryImplementor.getIndexBinding(this.entityClass);
            return indexBindingForEntity != null ? indexBindingForEntity.getEntityIndexingInterceptor() : null;
        }
    }
}

