/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.enhancements.association;

import java.io.IOException;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.search.PayloadIntDecodingIterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.collections.IntIterator;
import org.apache.lucene.util.collections.IntToIntMap;
import org.apache.lucene.util.encoding.SimpleIntDecoder;

public class AssociationsPayloadIterator {
    public static final Term ASSOCIATION_POSTING_TERM = new Term(CategoryListParams.DEFAULT_TERM.field(), "CATEGORY_ASSOCIATION_LIST");
    private IntToIntMap ordinalToAssociationMap;
    private PayloadIntDecodingIterator associationPayloadIter;
    private boolean hasAssociations = false;
    public static final long NO_ASSOCIATION = Integer.MIN_VALUE;

    public AssociationsPayloadIterator(IndexReader reader, String field) throws IOException {
        this.associationPayloadIter = new PayloadIntDecodingIterator(reader, new Term(field, "CATEGORY_ASSOCIATION_LIST"), new SimpleIntDecoder());
        this.hasAssociations = this.associationPayloadIter.init();
        this.ordinalToAssociationMap = new IntToIntMap();
    }

    public boolean setNextDoc(int docId) throws IOException {
        this.ordinalToAssociationMap.clear();
        boolean docContainsAssociations = false;
        try {
            docContainsAssociations = this.fetchAssociations(docId);
        }
        catch (IOException e) {
            IOException ioe = new IOException("An Error occured while reading a document's associations payload (docId=" + docId + ")");
            ioe.initCause(e);
            throw ioe;
        }
        return docContainsAssociations;
    }

    public long getAssociation(int ordinal) {
        if (this.ordinalToAssociationMap.containsKey(ordinal)) {
            return this.ordinalToAssociationMap.get(ordinal);
        }
        return Integer.MIN_VALUE;
    }

    public IntIterator getAssociatedOrdinals() {
        return this.ordinalToAssociationMap.keyIterator();
    }

    private boolean fetchAssociations(int docId) throws IOException {
        long ordinal;
        if (!this.hasAssociations) {
            return false;
        }
        if (!this.associationPayloadIter.skipTo(docId)) {
            return false;
        }
        while ((ordinal = this.associationPayloadIter.nextCategory()) <= Integer.MAX_VALUE) {
            long association = this.associationPayloadIter.nextCategory();
            if (association > Integer.MAX_VALUE) {
                throw new IOException("ERROR! Associations should come in pairs of (ordinal, value), yet this payload has an odd number of values! (docId=" + docId + ")");
            }
            this.ordinalToAssociationMap.put((int)ordinal, (int)association);
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.associationPayloadIter == null ? 0 : this.associationPayloadIter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssociationsPayloadIterator other = (AssociationsPayloadIterator)obj;
        return !(this.associationPayloadIter == null ? other.associationPayloadIter != null : !this.associationPayloadIter.equals(other.associationPayloadIter));
    }
}

