/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.batch.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.Helper;
import org.hibernate.search.batchindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.batchindexing.impl.SessionAwareRunnable;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.impl.HibernateSessionLoadingInitializer;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.interceptor.IndexingOverride;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.impl.HibernateHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IdentifierConsumerDocumentProducer
implements SessionAwareRunnable {
    private static final Log log = LoggerFactory.make();
    private final ProducerConsumerQueue<List<Serializable>> source;
    private final SessionFactory sessionFactory;
    private final CacheMode cacheMode;
    private final Class<?> type;
    private final MassIndexerProgressMonitor monitor;
    private final Map<Class<?>, EntityIndexBinding> entityIndexBinders;
    private final String idName;
    private final ErrorHandler errorHandler;
    private final BatchBackend backend;
    private final CountDownLatch producerEndSignal;

    public IdentifierConsumerDocumentProducer(ProducerConsumerQueue<List<Serializable>> fromIdentifierListToEntities, MassIndexerProgressMonitor monitor, SessionFactory sessionFactory, CountDownLatch producerEndSignal, CacheMode cacheMode, Class<?> type, SearchFactoryImplementor searchFactory, String idName, BatchBackend backend, ErrorHandler errorHandler) {
        this.source = fromIdentifierListToEntities;
        this.monitor = monitor;
        this.sessionFactory = sessionFactory;
        this.cacheMode = cacheMode;
        this.type = type;
        this.idName = idName;
        this.backend = backend;
        this.errorHandler = errorHandler;
        this.producerEndSignal = producerEndSignal;
        this.entityIndexBinders = searchFactory.getIndexBindings();
        log.trace((Object)"created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session upperSession) throws Exception {
        log.trace((Object)"started");
        Session session = upperSession;
        if (upperSession == null) {
            session = this.sessionFactory.openSession();
        }
        session.setFlushMode(FlushMode.MANUAL);
        session.setCacheMode(this.cacheMode);
        session.setDefaultReadOnly(true);
        try {
            Transaction transaction = Helper.getTransactionAndMarkForJoin(session);
            transaction.begin();
            this.loadAllFromQueue(session);
            transaction.commit();
        }
        catch (Exception exception) {
            this.errorHandler.handleException(log.massIndexerExceptionWhileTransformingIds(), (Throwable)exception);
        }
        finally {
            this.producerEndSignal.countDown();
            if (upperSession == null) {
                session.close();
            }
        }
        log.trace((Object)"finished");
    }

    private void loadAllFromQueue(Session session) {
        HibernateSessionLoadingInitializer sessionInitializer = new HibernateSessionLoadingInitializer((SessionImplementor)session);
        try {
            List<Serializable> take;
            do {
                if ((take = this.source.take()) == null) continue;
                List<Serializable> idList = take;
                log.tracef("received list of ids %s", idList);
                this.loadList(idList, session, sessionInitializer);
            } while (take != null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void loadList(List<Serializable> listIds, Session session, InstanceInitializer sessionInitializer) throws InterruptedException {
        Criteria criteria = session.createCriteria(this.type).setCacheMode(this.cacheMode).setLockMode(LockMode.NONE).setCacheable(false).setFlushMode(FlushMode.MANUAL).setFetchSize(listIds.size()).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY).add(Restrictions.in((String)this.idName, listIds));
        List list = criteria.list();
        this.monitor.entitiesLoaded(list.size());
        this.indexAllQueue(session, list, sessionInitializer);
        session.clear();
    }

    private void indexAllQueue(Session session, List<?> entities, InstanceInitializer sessionInitializer) {
        try {
            ContextualExceptionBridgeHelper contextualBridge = new ContextualExceptionBridgeHelper();
            if (entities == null || entities.isEmpty()) {
                return;
            }
            log.tracef("received a list of objects to index: %s", entities);
            for (Object object : entities) {
                try {
                    this.index(object, session, sessionInitializer, (ConversionContext)contextualBridge);
                    this.monitor.documentsBuilt(1);
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (RuntimeException e) {
                    String errorMsg = log.massIndexerUnableToIndexInstance(object.getClass().getName(), object.toString());
                    this.errorHandler.handleException(errorMsg, (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void index(Object entity, Session session, InstanceInitializer sessionInitializer, ConversionContext conversionContext) throws InterruptedException {
        Serializable id = session.getIdentifier(entity);
        Class<Object> clazz = HibernateHelper.getClass(entity);
        EntityIndexBinding entityIndexBinding = this.entityIndexBinders.get(clazz);
        if (entityIndexBinding == null) {
            return;
        }
        EntityIndexingInterceptor interceptor = entityIndexBinding.getEntityIndexingInterceptor();
        if (interceptor != null) {
            IndexingOverride onAdd = interceptor.onAdd(entity);
            switch (onAdd) {
                case REMOVE: 
                case SKIP: {
                    return;
                }
            }
        }
        DocumentBuilderIndexedEntity docBuilder = entityIndexBinding.getDocumentBuilder();
        TwoWayFieldBridge idBridge = docBuilder.getIdBridge();
        conversionContext.pushProperty(docBuilder.getIdKeywordName());
        String idInString = null;
        try {
            idInString = conversionContext.setClass(clazz).twoWayConversionContext(idBridge).objectToString((Object)id);
        }
        finally {
            conversionContext.popProperty();
        }
        AddLuceneWork addWork = docBuilder.createAddWork(clazz, entity, id, idInString, sessionInitializer, conversionContext);
        this.backend.enqueueAsyncWork((LuceneWork)addWork);
    }
}

