/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index.params;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.DefaultFacetIndexingParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerDimensionIndexingParams
extends DefaultFacetIndexingParams {
    private final Map<String, CategoryListParams> clParamsMap = new HashMap<String, CategoryListParams>();

    public PerDimensionIndexingParams() {
        this(new CategoryListParams());
    }

    public PerDimensionIndexingParams(CategoryListParams categoryListParams) {
        super(categoryListParams);
    }

    @Override
    public Iterable<CategoryListParams> getAllCategoryListParams() {
        ArrayList<CategoryListParams> vals = new ArrayList<CategoryListParams>(this.clParamsMap.values());
        for (CategoryListParams clp : super.getAllCategoryListParams()) {
            vals.add(clp);
        }
        return vals;
    }

    @Override
    public CategoryListParams getCategoryListParams(CategoryPath category) {
        CategoryListParams clParams;
        if (category != null && (clParams = this.clParamsMap.get(category.getComponent(0))) != null) {
            return clParams;
        }
        return super.getCategoryListParams(category);
    }

    public void addCategoryListParams(CategoryPath category, CategoryListParams clParams) {
        this.clParamsMap.put(category.getComponent(0), clParams);
    }
}

