/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.util.impl.ReflectionHelper;

public class PropertyMetadata {
    private final XProperty propertyAccessor;
    private final Map<String, DocumentFieldMetadata> documentFieldMetadata;
    private final Set<DocumentFieldMetadata> documentFieldMetadataSet;
    private final BoostStrategy dynamicBoostStrategy;

    private PropertyMetadata(Builder builder) {
        this.propertyAccessor = builder.propertyAccessor;
        this.documentFieldMetadataSet = Collections.unmodifiableSet(builder.fieldMetadataSet);
        this.documentFieldMetadata = this.createDocumentFieldMetadataMap(builder.fieldMetadataSet);
        this.dynamicBoostStrategy = builder.dynamicBoostStrategy != null ? builder.dynamicBoostStrategy : DefaultBoostStrategy.INSTANCE;
    }

    private Map<String, DocumentFieldMetadata> createDocumentFieldMetadataMap(Set<DocumentFieldMetadata> fieldMetadataSet) {
        HashMap<String, DocumentFieldMetadata> tmpMap = new HashMap<String, DocumentFieldMetadata>();
        for (DocumentFieldMetadata documentFieldMetadata : fieldMetadataSet) {
            tmpMap.put(documentFieldMetadata.getName(), documentFieldMetadata);
        }
        return Collections.unmodifiableMap(tmpMap);
    }

    public XProperty getPropertyAccessor() {
        return this.propertyAccessor;
    }

    public String getPropertyAccessorName() {
        return this.propertyAccessor == null ? null : this.propertyAccessor.getName();
    }

    public Set<DocumentFieldMetadata> getFieldMetadata() {
        return this.documentFieldMetadataSet;
    }

    public DocumentFieldMetadata getFieldMetadata(String fieldName) {
        return this.documentFieldMetadata.get(fieldName);
    }

    public BoostStrategy getDynamicBoostStrategy() {
        return this.dynamicBoostStrategy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PropertyMetadata{");
        sb.append("propertyAccessor=").append(this.propertyAccessor);
        sb.append(", fieldMetadata=").append(this.documentFieldMetadataSet);
        sb.append(", dynamicBoostStrategy=").append(this.dynamicBoostStrategy);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private final XProperty propertyAccessor;
        private final Set<DocumentFieldMetadata> fieldMetadataSet;
        private BoostStrategy dynamicBoostStrategy;

        public Builder(XProperty propertyAccessor) {
            if (propertyAccessor != null) {
                ReflectionHelper.setAccessible((XMember)propertyAccessor);
            }
            this.propertyAccessor = propertyAccessor;
            this.fieldMetadataSet = new HashSet<DocumentFieldMetadata>();
        }

        public Builder dynamicBoostStrategy(BoostStrategy boostStrategy) {
            this.dynamicBoostStrategy = boostStrategy;
            return this;
        }

        public Builder addDocumentField(DocumentFieldMetadata documentFieldMetadata) {
            this.fieldMetadataSet.add(documentFieldMetadata);
            return this;
        }

        public XProperty getPropertyAccessor() {
            return this.propertyAccessor;
        }

        public PropertyMetadata build() {
            return new PropertyMetadata(this);
        }
    }
}

