/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.JSONWriter;
import org.apache.solr.response.SolrQueryResponse;

abstract class NaNFloatWriter
extends JSONWriter {
    protected abstract String getNaN();

    protected abstract String getInf();

    public NaNFloatWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
    }

    public void writeFloat(String name, float val) throws IOException {
        if (Float.isNaN(val)) {
            this.writer.write(this.getNaN());
        } else if (Float.isInfinite(val)) {
            if (val < 0.0f) {
                this.writer.write('-');
            }
            this.writer.write(this.getInf());
        } else {
            this.writeFloat(name, Float.toString(val));
        }
    }

    public void writeDouble(String name, double val) throws IOException {
        if (Double.isNaN(val)) {
            this.writer.write(this.getNaN());
        } else if (Double.isInfinite(val)) {
            if (val < 0.0) {
                this.writer.write('-');
            }
            this.writer.write(this.getInf());
        } else {
            this.writeDouble(name, Double.toString(val));
        }
    }
}

