/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan.impl;

import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.batchindexing.impl.Executors;
import org.hibernate.search.infinispan.impl.AsyncDeleteExecutorService;
import org.hibernate.search.infinispan.logging.impl.Log;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultAsyncDeleteExecutorServiceProvider
implements AsyncDeleteExecutorService {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private ThreadPoolExecutor threadPool;

    public void start(Properties properties, BuildContext context) {
        this.threadPool = Executors.newScalableThreadPool((int)1, (int)5, (String)"async deletion of index segments", (int)100);
    }

    public void stop() {
        this.closeAndFlush();
    }

    public AsyncDeleteExecutorService getService() {
        return this;
    }

    @Override
    public void closeAndFlush() {
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.interruptedWhileWaitingForAsyncDeleteFlush();
        }
    }

    @Override
    public Executor getExecutor() {
        return this.threadPool;
    }
}

