/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.range.RangeFacetRequest;
import org.apache.lucene.facet.range.RangeFacetResultNode;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.queries.function.FunctionValues;

public class RangeAccumulator
extends FacetsAccumulator {
    public RangeAccumulator(FacetRequest ... facetRequests) {
        this(Arrays.asList(facetRequests));
    }

    public RangeAccumulator(List<FacetRequest> facetRequests) {
        super(new FacetSearchParams(facetRequests));
        for (FacetRequest fr : facetRequests) {
            if (!(fr instanceof RangeFacetRequest)) {
                throw new IllegalArgumentException("this accumulator only supports RangeFacetRequest; got " + fr);
            }
            if (fr.categoryPath.length == 1) continue;
            throw new IllegalArgumentException("only flat (dimension only) CategoryPath is allowed");
        }
    }

    @Override
    public List<FacetResult> accumulate(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        for (FacetRequest req : this.searchParams.facetRequests) {
            RangeFacetRequest rangeFR = (RangeFacetRequest)req;
            int[] counts = new int[rangeFR.ranges.length];
            for (FacetsCollector.MatchingDocs hits : matchingDocs) {
                FunctionValues fv = rangeFR.getValues(hits.context);
                int length = hits.bits.length();
                int doc = 0;
                while (doc < length && (doc = hits.bits.nextSetBit(doc)) != -1) {
                    if (!fv.exists(doc)) {
                        ++doc;
                        continue;
                    }
                    long v = fv.longVal(doc);
                    for (int j = 0; j < rangeFR.ranges.length; ++j) {
                        if (!rangeFR.ranges[j].accept(v)) continue;
                        int n = j;
                        counts[n] = counts[n] + 1;
                    }
                    ++doc;
                }
            }
            ArrayList<FacetResultNode> nodes = new ArrayList<FacetResultNode>(rangeFR.ranges.length);
            for (int j = 0; j < rangeFR.ranges.length; ++j) {
                nodes.add(new RangeFacetResultNode(rangeFR.label, rangeFR.ranges[j], counts[j]));
            }
            FacetResultNode rootNode = new FacetResultNode(-1, 0.0);
            rootNode.label = rangeFR.categoryPath;
            rootNode.subResults = nodes;
            results.add(new FacetResult(req, rootNode, nodes.size()));
        }
        return results;
    }

    @Override
    public boolean requiresDocScores() {
        return false;
    }
}

