/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader.impl;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.reader.impl.ReaderProviderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class MultiReaderFactory {
    private static final Log log = LoggerFactory.make();

    private MultiReaderFactory() {
    }

    public static IndexReader openReader(IndexManager ... indexManagers) {
        int length = indexManagers.length;
        IndexReader[] readers = new IndexReader[length];
        ReaderProvider[] managers = new ReaderProvider[length];
        for (int index = 0; index < length; ++index) {
            IndexReader openIndexReader;
            ReaderProvider indexReaderManager = indexManagers[index].getReaderProvider();
            readers[index] = openIndexReader = indexReaderManager.openIndexReader();
            managers[index] = indexReaderManager;
        }
        return ReaderProviderHelper.buildMultiReader(length, readers, managers);
    }

    public static void closeReader(IndexReader multiReader) {
        if (multiReader == null) {
            return;
        }
        try {
            multiReader.close();
        }
        catch (IOException e) {
            log.couldNotCloseResource(e);
        }
    }
}

