/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import org.apache.lucene.facet.collections.IntToDoubleMap;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public class DistanceCollector
extends Collector {
    private Collector delegate;
    private boolean acceptsDocsOutOfOrder;
    private Point center;
    private String latitudeField;
    private String longitudeField;
    private int docBase = 0;
    private IntToDoubleMap distances;
    private IntToDoubleMap latitudeValues;
    private IntToDoubleMap longitudeValues;

    public DistanceCollector(Collector delegate, Coordinates centerCoordinates, int hitsCount, String fieldname) {
        this.delegate = delegate;
        this.acceptsDocsOutOfOrder = delegate.acceptsDocsOutOfOrder();
        this.center = Point.fromCoordinates(centerCoordinates);
        this.distances = new IntToDoubleMap(hitsCount);
        this.latitudeValues = new IntToDoubleMap(hitsCount);
        this.longitudeValues = new IntToDoubleMap(hitsCount);
        this.latitudeField = SpatialHelper.formatLatitude(fieldname);
        this.longitudeField = SpatialHelper.formatLongitude(fieldname);
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }

    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
        int absolute = this.docBase + doc;
        this.distances.put(absolute, this.center.getDistanceTo(this.latitudeValues.get(absolute), this.longitudeValues.get(absolute)));
    }

    public void setNextReader(AtomicReaderContext newContext) throws IOException {
        this.delegate.setNextReader(newContext);
        AtomicReader atomicReader = newContext.reader();
        int numDocs = atomicReader.numDocs();
        FieldCache.Doubles unbasedLatitudeValues = FieldCache.DEFAULT.getDoubles(atomicReader, this.latitudeField, false);
        FieldCache.Doubles unbasedLongitudeValues = FieldCache.DEFAULT.getDoubles(atomicReader, this.longitudeField, false);
        this.docBase = newContext.docBase;
        for (int i = 0; i < numDocs; ++i) {
            this.latitudeValues.put(this.docBase + i, unbasedLatitudeValues.get(i));
            this.longitudeValues.put(this.docBase + i, unbasedLongitudeValues.get(i));
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.acceptsDocsOutOfOrder;
    }

    public double getDistance(int index) {
        return this.distances.get(index);
    }
}

