/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.hibernate.search.SearchException;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.FileHelper;

public class HibernateSearchResourceLoader
implements ResourceLoader {
    private final ClassLoader classLoader;

    @Deprecated
    public HibernateSearchResourceLoader() {
        this.classLoader = HibernateSearchResourceLoader.class.getClassLoader();
    }

    public HibernateSearchResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public InputStream openResource(String resource) throws IOException {
        InputStream inputStream = FileHelper.openResource(resource);
        if (inputStream == null) {
            throw new SearchException("Resource not found: " + resource);
        }
        return inputStream;
    }

    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        return ClassLoaderHelper.classForName(expectedType, cname, this.classLoader, HibernateSearchResourceLoader.describeComponent(cname));
    }

    public <T> T newInstance(String cname, Class<T> expectedType) {
        return ClassLoaderHelper.instanceFromName(expectedType, cname, this.classLoader, HibernateSearchResourceLoader.describeComponent(cname));
    }

    private static String describeComponent(String classname) {
        return "Lucene Analyzer component " + classname;
    }
}

