/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SingletonSortedSetDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public final class DocValues {
    public static final BinaryDocValues EMPTY_BINARY = new BinaryDocValues(){

        @Override
        public void get(int docID, BytesRef result) {
            result.bytes = BytesRef.EMPTY_BYTES;
            result.offset = 0;
            result.length = 0;
        }
    };
    public static final NumericDocValues EMPTY_NUMERIC = new NumericDocValues(){

        @Override
        public long get(int docID) {
            return 0L;
        }
    };
    public static final SortedDocValues EMPTY_SORTED = new SortedDocValues(){

        @Override
        public int getOrd(int docID) {
            return -1;
        }

        @Override
        public void lookupOrd(int ord, BytesRef result) {
            result.bytes = BytesRef.EMPTY_BYTES;
            result.offset = 0;
            result.length = 0;
        }

        @Override
        public int getValueCount() {
            return 0;
        }
    };
    public static final SortedSetDocValues EMPTY_SORTED_SET = new RandomAccessOrds(){

        @Override
        public long nextOrd() {
            return -1L;
        }

        @Override
        public void setDocument(int docID) {
        }

        @Override
        public void lookupOrd(long ord, BytesRef result) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public long getValueCount() {
            return 0L;
        }

        @Override
        public long ordAt(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int cardinality() {
            return 0;
        }
    };

    private DocValues() {
    }

    public static SortedSetDocValues singleton(SortedDocValues dv) {
        return new SingletonSortedSetDocValues(dv);
    }

    public static SortedDocValues unwrapSingleton(SortedSetDocValues dv) {
        if (dv instanceof SingletonSortedSetDocValues) {
            return ((SingletonSortedSetDocValues)dv).getSortedDocValues();
        }
        return null;
    }

    public static Bits docsWithValue(final SortedDocValues dv, final int maxDoc) {
        return new Bits(){

            @Override
            public boolean get(int index) {
                return dv.getOrd(index) >= 0;
            }

            @Override
            public int length() {
                return maxDoc;
            }
        };
    }

    public static Bits docsWithValue(final SortedSetDocValues dv, final int maxDoc) {
        return new Bits(){

            @Override
            public boolean get(int index) {
                dv.setDocument(index);
                return dv.nextOrd() != -1L;
            }

            @Override
            public int length() {
                return maxDoc;
            }
        };
    }
}

