/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.logging.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.lucene.index.CorruptIndexException;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.EmptyQueryException;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Serializable,
Log,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final String initializedBlackholeBackend = "HSEARCH000001: initialized \"blackhole\" backend. Index changes will be prepared but discarded!";
    private static final String closedBlackholeBackend = "HSEARCH000002: closed \"blackhole\" backend.";
    private static final String incorrectMessageType = "HSEARCH000016: Incorrect message type: %1$s";
    private static final String interruptedWorkError = "HSEARCH000017: Work discarded, thread was interrupted while waiting for space to schedule: %1$s";
    private static final String skippingDirectorySynchronization = "HSEARCH000018: Skipping directory synchronization, previous work still in progress: %1$s";
    private static final String unableToRemovePreviousMarket = "HSEARCH000019: Unable to remove previous marker file from source of %1$s";
    private static final String unableToCreateCurrentMarker = "HSEARCH000020: Unable to create current marker in source of %1$s";
    private static final String unableToSynchronizeSource = "HSEARCH000021: Unable to synchronize source of %1$s";
    private static final String unableToDetermineCurrentInSourceDirectory = "HSEARCH000022: Unable to determine current in source directory, will try again during the next synchronization";
    private static final String unableToCompareSourceWithDestinationDirectory = "HSEARCH000023: Unable to compare %1$s with %2$s.";
    private static final String idCannotBeExtracted = "HSEARCH000024: Unable to reindex entity on collection change, id cannot be extracted: %1$s";
    private static final String serviceProviderNotReleased = "HSEARCH000025: Service provider has been used but not released: %1$s";
    private static final String stopServiceFailed = "HSEARCH000026: Fail to properly stop service: %1$s";
    private static final String indexingEntities = "HSEARCH000027: Going to reindex %d entities";
    private static final String indexingEntitiesCompleted = "HSEARCH000028: Reindexed %1$d entities";
    private static final String indexingCompletedAndMBeanUnregistered = "HSEARCH000029: Indexing completed. Reindexed %1$d entities. Unregistering MBean from server";
    private static final String indexingDocumentsCompleted = "HSEARCH000030: %1$d documents indexed in %2$d ms";
    private static final String indexingSpeed = "HSEARCH000031: Indexing speed: %1$f documents/second; progress: %2$.2f%%";
    private static final String notDeleted = "HSEARCH000032: Could not delete %1$s";
    private static final String notChangeTimestamp = "HSEARCH000033: Could not change timestamp for %1$s. Index synchronization may be slow.";
    private static final String version = "HSEARCH000034: Hibernate Search %1$s";
    private static final String couldNotCloseResource = "HSEARCH000035: Could not close resource.";
    private static final String cannotGuessTransactionStatus = "HSEARCH000036: Cannot guess the Transaction Status: not starting a JTA transaction";
    private static final String unableToCloseSearcherDuringQuery = "HSEARCH000037: Unable to properly close searcher during lucene query: %1$s";
    private static final String forceToUseDocumentExtraction = "HSEARCH000038: Forced to use Document extraction to workaround FieldCache bug in Lucene";
    private static final String unableToCloseSearcherInScrollableResult = "HSEARCH000039: Unable to properly close searcher in ScrollableResults";
    private static final String unexpectedValueMissingFromFieldCache = "HSEARCH000040: Unexpected: value is missing from FieldCache. This is likely a bug in the FieldCache implementation, Hibernate Search might have to workaround this by slightly inaccurate faceting values or reduced performance.";
    private static final String indexDirectoryNotFoundCreatingNewOne = "HSEARCH000041: Index directory not found, creating: '%1$s'";
    private static final String noCurrentMarkerInSourceDirectory = "HSEARCH000042: No current marker in source directory. Has the master being started already?";
    private static final String foundCurrentMarker = "HSEARCH000043: Found current marker in source directory - initialization succeeded";
    private static final String abstractClassesCannotInsertDocuments = "HSEARCH000044: Abstract classes cannot be indexed directly. Only concrete subclasses can be indexed. @Indexed on '%s' is superfluous and should be removed.";
    private static final String containedInPointsToProvidedId = "HSEARCH000045: @ContainedIn is pointing to an entity having @ProvidedId: %1$s. This is not supported, indexing of contained in entities will be skipped. Indexed data of the embedded object might become out of date in objects of type ";
    private static final String cannotExtractValueForIdentifier = "HSEARCH000046: FieldCache was enabled on class %1$s but for this type of identifier we can't extract values from the FieldCache: cache disabled";
    private static final String unableToCloseJmsConnection = "HSEARCH000047: Unable to close JMS connection for %1$s";
    private static final String unableToRetrieveNamedAnalyzer = "HSEARCH000048: Unable to retrieve named analyzer: %1$s";
    private static final String interruptedWhileWaitingForIndexActivity = "HSEARCH000049: Was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    private static final String pushedChangesOutOfTransaction = "HSEARCH000050: It appears changes are being pushed to the index out of a transaction. Register the IndexWorkFlushEventListener listener on flush to correctly manage Collections!";
    private static final String forcingReleaseIndexWriterLock = "HSEARCH000052: Going to force release of the IndexWriter lock";
    private static final String checkSizeMustBePositive = "HSEARCH000053: Chunk size must be positive: using default value.";
    private static final String readersNotProperlyClosedInReaderProvider = "HSEARCH000054: ReaderProvider contains readers not properly closed at destroy time";
    private static final String unableToCloseLuceneIndexReader = "HSEARCH000055: Unable to close Lucene IndexReader";
    private static final String unableToUnregisterExistingMBean = "HSEARCH000056: Unable to un-register existing MBean: %1$s";
    private static final String exceptionOccurred = "HSEARCH000058: %1$s";
    private static final String workerException = "HSEARCH000059: Worker raises an exception on close()";
    private static final String interruptedBatchIndexing = "HSEARCH000062: Batch indexing was interrupted";
    private static final String errorRollingBackTransaction = "HSEARCH000065: Error while rolling back transaction after %1$s";
    private static final String failedSlaveDirectoryProviderInitialization = "HSEARCH000066: Failed to initialize SlaveDirectoryProvider %1$s";
    private static final String unableToCloseLuceneDirectory = "HSEARCH000067: Unable to properly close Lucene directory %1$s";
    private static final String unableToRetrieveObjectFromMessage = "HSEARCH000068: Unable to retrieve object from message: %1$s";
    private static final String illegalObjectRetrievedFromMessage = "HSEARCH000069: Illegal object retrieved from message";
    private static final String cannotOpenIndexWriterCausePreviousError = "HSEARCH000072: Couldn't open the IndexWriter because of previous error: operation skipped, index ouf of sync!";
    private static final String backendError = "HSEARCH000073: Error in backend";
    private static final String recommendConfiguringLuceneVersion = "HSEARCH000075: Configuration setting hibernate.search.lucene_version was not specified: using LUCENE_CURRENT.";
    private static final String cantOpenCorruptedIndex = "HSEARCH000076: Could not open Lucene index: index data is corrupted. index name: '%1$s'";
    private static final String ioExceptionOnIndex = "HSEARCH000077: An IOException happened while accessing the Lucene index '%1$s'";
    private static final String unableToShutdownAsynchronousIndexingByTimeout = "HSEARCH000078: Timed out waiting to flush all operations to the backend of index %1$s";
    private static final String serializationProtocol = "HSEARCH000079: Serialization protocol version %1$d.%2$d initialized";
    private static final String messageReceivedForUndefinedIndex = "HSEARCH000080: Received a remote message about an unknown index '%1$s': discarding message!";
    private static final String warnSuspiciousBackendDirectoryCombination = "HSEARCH000081: The index '%1$s' is using a non-recommended combination of backend and directoryProvider implementations";
    private static final String unableToSerializeLuceneWorks = "HSEARCH000083: Unable to serialize List<LuceneWork>";
    private static final String unableToReadSerializedLuceneWorks = "HSEARCH000084: Unable to read serialized List<LuceneWork>";
    private static final String attributeNotRecognizedNorSerializable = "HSEARCH000085: Attribute type is not recognized and not serializable: %1$s";
    private static final String unknownAttributeSerializedRepresentation = "HSEARCH000086: Unknown attribute serialized representation: %1$s";
    private static final String unableToReadTokenStream = "HSEARCH000087: Unable to read TokenStream";
    private static final String unableToConvertSerializableTermVectorToLuceneTermVector = "HSEARCH000088: Unable to convert serializable TermVector to Lucene TermVector: %1$s";
    private static final String unableToConvertSerializableIndexToLuceneIndex = "HSEARCH000089: Unable to convert serializable Index to Lucene Index: %1$s";
    private static final String unableToConvertSerializableStoreToLuceneStore = "HSEARCH000090: Unable to convert serializable Store to Lucene Store: %1$s";
    private static final String unknownNumericFieldType = "HSEARCH000091: Unknown NumericField type: %1$s";
    private static final String conversionFromReaderToStringNotYetImplemented = "HSEARCH000092: Conversion from Reader to String not yet implemented";
    private static final String unknownFieldType = "HSEARCH000093: Unknown Field type: %1$s";
    private static final String cannotSerializeCustomField = "HSEARCH000094: Cannot serialize custom Fieldable '%1$s'. Must be NumericField, Field or a Serializable Fieldable implementation.";
    private static final String failToSerializeObject = "HSEARCH000095: Fail to serialize object of type %1$s";
    private static final String failToDeserializeObject = "HSEARCH000096: Fail to deserialize object";
    private static final String incompatibleProtocolVersion = "HSEARCH000098: Unable to parse message from protocol version %1$d.%2$d. Current protocol version: %3$d.%4$d";
    private static final String unableToDeserializeAvroStream = "HSEARCH000099: Unable to deserialize Avro stream";
    private static final String cannotDeserializeOperation = "HSEARCH000100: Cannot deserialize operation %1$s, unknown operation.";
    private static final String cannotDeserializeField = "HSEARCH000101: Cannot deserialize field type %1$s, unknown field type.";
    private static final String unableToSerializeInAvro = "HSEARCH000102: Unable to serialize Lucene works in Avro";
    private static final String unableToInitializeIndexManager = "HSEARCH000103: Unable to initialize IndexManager named '%1$s'";
    private static final String ignoringBackendOptionForIndex = "HSEARCH000104: Ignoring backend option for index '%1$s', configured IndexManager requires using '%2$s' instead.";
    private static final String cannotGetResultSizeWithCriteriaAndRestriction = "HSEARCH000105: Cannot safely compute getResultSize() when a Criteria with restriction is used. Use query.list().size() or query.getResultList().size(). Criteria at stake: %1$s";
    private static final String fieldLooksBinaryButDecompressionFailed = "HSEARCH000106: Field %1$s looks like binary but couldn't be decompressed";
    private static final String requestedIndexNotDefined = "HSEARCH000107: Index names %1$s is not defined";
    private static final String shuttingDownBackend = "HSEARCH000108: Shutting down backend for IndexManager '%1$s'";
    private static final String notAnIndexedType = "HSEARCH000109: %1$s is not an indexed type";
    private static final String nullIsInvalidIndexedType = "HSEARCH000110: 'null' is not a valid indexed type";
    private static final String needAtLeastOneIndexName = "HSEARCH000111: At least one index name must be provided: can't open an IndexReader on nothing";
    private static final String needAtLeastOneIndexedEntityType = "HSEARCH000112: At least one entity type must be provided: can't open an IndexReader on nothing";
    private static final String nullIsInvalidIndexName = "HSEARCH000113: 'null' is not a valid index name";
    private static final String unableToLoadResource = "HSEARCH000114: Could not load resource: '%1$s'";
    private static final String unknownFullTextFilter = "HSEARCH000115: Unknown @FullTextFilter: '%1$s'";
    private static final String massIndexerUnexpectedErrorMessage = "HSEARCH000116: Unexpected error during MassIndexer operation";
    private static final String ioExceptionOnIndexWriter = "HSEARCH000117: IOException on the IndexWriter";
    private static final String exceptionDuringIndexMergeOperation = "HSEARCH000118: Exception during index Merge operation";
    private static final String optimizationSkippedStillBusy = "HSEARCH000119: Skipping optimization on index %1$s as it is already being optimized";
    private static final String inconsistentFieldConfiguration = "HSEARCH000120: There are multiple properties indexed against the same field name '%1$s.%2$s', but with different indexing settings. The behaviour is undefined.";
    private static final String forceSkipIndexOperationViaInterception = "HSEARCH000125: Interceptor enforces skip index operation %2$s on instance of class %1$s";
    private static final String forceRemoveOnIndexOperationViaInterception = "HSEARCH000126: Interceptor enforces removal of index data instead of index operation %2$s on instance of class %1$s";
    private static final String forceUpdateOnIndexOperationViaInterception = "HSEARCH000128: Interceptor enforces update of index data instead of index operation %2$s on instance of class %1$s";
    private static final String targetedFieldNotSpatial = "HSEARCH000131: The field used for the spatial query is not using SpatialFieldBridge: %1$s.%2$s";
    private static final String noFieldBridgeInterfaceImplementedByClassBridge = "HSEARCH000133: @ClassBridge implementation '%1$s' should implement either org.hibernate.search.bridge.FieldBridge, org.hibernate.search.bridge.TwoWayStringBridge or org.hibernate.search.bridge.StringBridge";
    private static final String cannotInstantiateClassBridgeOfType = "HSEARCH000134: Unable to instantiate ClassBridge of type %1$s defined on %2$s";
    private static final String unableToGuessFieldBridge = "HSEARCH000135: Unable to guess FieldBridge for %2$s in %1$s";
    private static final String unableToInstantiateSpatial = "HSEARCH000136: Unable to instantiate Spatial defined on %1$s";
    private static final String noImplementationClassInFieldBridge = "HSEARCH000137: @FieldBridge with no implementation class defined in: %1$s";
    private static final String noFieldBridgeInterfaceImplementedByFieldBridge = "HSEARCH000138: @FieldBridge implementation implements none of the field bridge interfaces: %1$s in %2$s";
    private static final String unableToInstantiateFieldBridge = "HSEARCH000139: Unable to instantiate FieldBridge for %1$s of class %2$s";
    private static final String unknownResolution = "HSEARCH000140: Unknown Resolution: %1$s";
    private static final String fieldBridgeNotAnInstanceof = "HSEARCH000144: FieldBridge passed in is not an instance of %1$s";
    private static final String queryWithNoTermsAfterAnalysis = "HSEARCH000146: The query string '%2$s' applied on field '%1$s' has no meaningfull tokens to be matched. Validate the query input against the Analyzer applied on this field.";
    private static final String unableToDetermineClassBridge = "HSEARCH000149: Unable to determine ClassBridge for %1$s";
    private static final String unableToGetInputStreamFromBlob = "HSEARCH000150: Unable to get input stream from blob data";
    private static final String unsupportedTikaBridgeType = "HSEARCH000151: Unable to get input stream from object of type %1$s";
    private static final String fileDoesNotExist = "HSEARCH000152: File %1$s does not exist";
    private static final String fileIsADirectory = "HSEARCH000153: %1$s is a directory and not a file";
    private static final String fileIsNotReadable = "HSEARCH000154: File %1$s is not readable";
    private static final String unableToConfigureTikaBridge = "HSEARCH000155: Unable to configure %1$s";
    private static final String cannotReadFieldForClass = "HSEARCH000156: Cannot read %1$s field from a %2$s object : does getter exists and is it public ?";
    private static final String cannotExtractCoordinateFromObject = "HSEARCH000157: Class %1$s does not implement the Coordinates interface";
    private static final String cannotHaveTwoSpatialsWithDefaultOrSameName = "HSEARCH000158: Class %1$s cannot have two @Spatial using default/same name";
    private static final String cannotFindCoordinatesNorLatLongForSpatial = "HSEARCH000159: Cannot find a Coordinates interface nor @Latitude/@Longitude annotations bound to the @Spatial name '%1$s' for class %2$s. It might be a typo (or a lapse) in @Latitude.of / @Longitude.of attributes.";
    private static final String ambiguousLatitudeDefinition = "HSEARCH000160: @Latitude definition for class '%1$s' is ambiguous: specified on both fields '%2$s' and '%3$s'";
    private static final String ambiguousLongitudeDefinition = "HSEARCH000161: @Longitude definition for class '%1$s' is ambiguous: specified on both fields '%2$s' and '%3$s'";
    private static final String unableToOpenJMSConnection = "HSEARCH000162: Unable to open JMS connection on queue '%2$s' for index '%1$s'";
    private static final String unableToSendJMSWork = "HSEARCH000163: Unable to send Search work to JMS queue '%2$s' for index '%1$s'";
    private static final String jmsQueueLookupException = "HSEARCH000164: Unable to lookup Search queue '%1$s' for index '%2$s'";
    private static final String indexManagerAliasResolved = "HSEARCH000166: IndexManager factory resolved alias '%1$s' to '%2$s'.";
    private static final String duplicateDocumentIdFound = "HSEARCH000167: More than one @DocumentId specified on entity '%1$s'";
    private static final String indexManagerUsesSerializationService = "HSEARCH000168: Serialization service %2$s being used for index '%1$s'";
    private static final String fieldBridgeNotTwoWay = "HSEARCH000169: FieldBridge '%1$s' does not have a objectToString method: field '%2$s' in '%3$s' The FieldBridge must be a TwoWayFieldBridge or you have to enable the ignoreFieldBridge option when defining a Query";
    private static final String unableToParseDocument = "HSEARCH000176: Document could not be parsed";
    private static final String noDocumentIdFoundException = "HSEARCH000177: Unable to find a valid document id for entity '%1$s'";
    private static final String getNullSessionPassedToFullTextSessionCreationException = "HSEARCH000178: Unable to create a FullTextSession from a null Session";
    private static final String getNullSessionPassedToFullEntityManagerCreationException = "HSEARCH000179: Unable to create a FullTextEntityManager from a null EntityManager";
    private static final String getUnableToNarrowFieldDescriptorException = "HSEARCH000180: Unable to cast %s of type %s to %s";
    private static final String getPropertyNameCannotBeNullException = "HSEARCH000181: 'null' is not a valid property name";
    private static final String getFieldNameCannotBeNullException = "HSEARCH000182: 'null' is not a valid field name";
    private static final String massIndexerUnableToIndexInstance = "HSEARCH000183: Unable to index instance of type %s while batch indexing: %s";
    private static final String entityWithNoShard = "HSEARCH000184: Cannot define an entity with 0 shard on '%1$s'";
    private static final String assertionFailureCannotCastToWorkerBuilderContext = "HSEARCH000186: [AssertionFailure: open a bug report] SearchFactory from entityIndexBinding is not assignable to WorkerBuilderContext. Actual class is %1$s";
    private static final String getMultipleEntitiesShareIndexWithInconsistentSimilarityException = "HSEARCH000189: Multiple entities are sharing the same index but are declaring an inconsistent Similarity. When overriding default Similarity make sure that all types sharing a same index declare the same Similarity implementation. %s defines similarity %s and %s defines similarity %s";
    private static final String getNoSessionFactoryInContextException = "HSEARCH000190: Unable to start HibernateSessionFactoryServiceProvider. There is no session factory in the context. Are you sure you have Hibernate ORM enabled?";
    private static final String getInvalidShardCountException = "HSEARCH000191: The number of shards must be >= 1. %s is an illegal value.";
    private static final String getInvalidIntegerValueException = "HSEARCH000192: %s";
    private static final String idHashShardingWithSingleShard = "HSEARCH000193: Selected sharding strategy is IdHashShardingStrategy. However, there is only 1 shard configured. Have you set the 'nbr_of_shards' property?";
    private static final String getUnableToLoadShardingStrategyClassException = "HSEARCH000194: Unable to load configured class '%s' as 'sharding_strategy'";
    private static final String getMultipleServiceImplementationsException = "HSEARCH000195: Multiple service implementations detected for service '%1$s': '%2$s'";
    private static final String getNoServiceImplementationFoundException = "HSEARCH000196: No service implementations for service '%1$s' can be found";
    private static final String getUnableToCreateJGroupsBackendException = "HSEARCH000197: Unable to create JGroups backend. Are you sure you have the JGroups dependencies on the classpath?";
    private static final String getUnexpectedServiceStatusException = "HSEARCH000198: Unexpected status '%s' for service '%s'. Check for circular dependencies or unreleased resources in your services.";
    private static final String configurationPropertyCantBeEmpty = "HSEARCH000199: Configuration property '%s' should not be empty: illegal format.";
    private static final String incorrectEditDistance = "HSEARCH000201: The edit distance must be either 1 or 2";
    private static final String entityWithIdNotFound = "HSEARCH000202: Unable to find entity $1%s with id $2%s";
    private static final String noFieldCompatibleForMoreLikeThis = "HSEARCH000203: No field from %s can be used for More Like This queries. They are neither stored or including the term vectors.";
    private static final String ioExceptionOnIndexOfEntity = "HSEARCH000205: An IOException happened while accessing the Lucene indexes related to '%1$s'";
    private static final String requireTFIDFSimilarity = "HSEARCH000206: MoreLikeThis queries require a TFIDFSimilarity for entity '$1%s'";
    private static final String fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis = "HSEARCH000207: Field %s of entity %s cannot be used in a MoreLikeThis query: the term vector (preferred) or the value itself need to be stored.";
    private static final String classLoaderServiceContainedInProvidedServicesException = "HSEARCH000208: ClassLoaderService cannot be provided via SearchConfiguration#getProvidedServices. Use SearchConfiguration#getClassLoaderService!";
    private static final String serviceRequestedAfterReleasedAllWasCalled = "HSEARCH000209: It is not allowed to request further services after ServiceManager#releaseAll has been called.";
    private static final String providedServicesCannotImplementStartableOrStoppable = "HSEARCH000210: Provided service '%s' implements '%s'. Provided services are not allowed to implement either Startable or Stoppable.";
    private static final String massIndexerExceptionWhileFetchingIds = "HSEARCH000211: An exception occurred while the MassIndexer was fetching the primary identifiers list";
    private static final String massIndexerExceptionWhileTransformingIds = "HSEARCH000212: An exception occurred while the MassIndexer was transforming identifiers to Lucene Documents";
    private static final String fieldIdCannotBeUsedInMoreLikeThis = "HSEARCH000213: Field %s of entity %s cannot be used in a MoreLikeThis query. Ids and embedded ids are excluded.";
    private static final String numericFieldCannotBeUsedInMoreLikeThis = "HSEARCH000214: Field %s of entity %s cannot be used in a MoreLikeThis query. Numeric fields are not considered for the moment.";
    private static final String multipleMatchingFieldBridges = "HSEARCH000215: Multiple matching FieldBridges found for %s of return type %s: %s";
    private static final String invalidIncludePathConfiguration = "HSEARCH000216: Found invalid @IndexedEmbedded->paths elements configured for member '%s' of class '%s'. The invalid paths are [%s]";
    private static final String invalidPropertyValue = "HSEARCH000217: Invalid value '%s' for setting '%s'. Check the documentation for allowed values.";
    private static final String unknownFieldNameForMoreLikeThisQuery = "HSEARCH000218: More like this query cannot be created, because the index does not contain a field '%s' for the type '%s";
    private static final String jmsInitialContextException = "HSEARCH000219: Could not lookup initial JNDI context for the JMS ConnectionFactory named '%s' for the index '%s";
    private static final String jmsQueueFactoryLookupException = "HSEARCH000220: Could not lookup JMS ConnectionFactory named '%1s' for the index '%2s";
    private static final String detectInfiniteTypeLoopInIndexedEmbedded = "HSEARCH000221: Circular reference. Duplicate use of %1s in root entity %2s#%3s Set the @IndexedEmbedded.depth value explicitly to fix the problem.";
    private static final String searchFactoryNotInitialized = "HSEARCH000222: The SearchFactory was not initialized";
    private static final String searchFactoryReferenceServiceNotFound = "HSEARCH000223: The Service org.hibernate.search.hcore.impl.SearchFactoryReference was not found in the Hibernate ORM Service Registry. This might be caused by the Hibernate ORM classloader not having visibility on Hibernate Search";
    private static final String parametersShouldNotBeNull = "HSEARCH000224: Non optional parameter named '%s' was null";
    private static final String lockingFailureDuringInitialization = "HSEARCH000225: An index locking error occurred during initialization of Directory '%s'. This might indicate a concurrent initialization; If you experience errors on this index you might need to remove the lock, or rebuild the index.";
    private static final String logInfoStreamMessage = "HSEARCH000226: %s: %s";
    private static final String booleanQueryWithoutClauses = "HSEARCH000227: A BooleanQuery is not valid without at least one clause. Use at least one of should(Query) or must(Query).";

    public Log_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void initializedBlackholeBackend() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.initializedBlackholeBackend$str(), new Object[0]);
    }

    protected String initializedBlackholeBackend$str() {
        return initializedBlackholeBackend;
    }

    @Override
    public final void closedBlackholeBackend() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.closedBlackholeBackend$str(), new Object[0]);
    }

    protected String closedBlackholeBackend$str() {
        return closedBlackholeBackend;
    }

    public final void incorrectMessageType(Class messageType) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.incorrectMessageType$str(), (Object)messageType);
    }

    protected String incorrectMessageType$str() {
        return incorrectMessageType;
    }

    @Override
    public final void interruptedWorkError(Runnable r) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedWorkError$str(), (Object)r);
    }

    protected String interruptedWorkError$str() {
        return interruptedWorkError;
    }

    @Override
    public final void skippingDirectorySynchronization(String indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.skippingDirectorySynchronization$str(), (Object)indexName);
    }

    protected String skippingDirectorySynchronization$str() {
        return skippingDirectorySynchronization;
    }

    @Override
    public final void unableToRemovePreviousMarket(String indexName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToRemovePreviousMarket$str(), (Object)indexName);
    }

    protected String unableToRemovePreviousMarket$str() {
        return unableToRemovePreviousMarket;
    }

    @Override
    public final void unableToCreateCurrentMarker(String indexName, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCreateCurrentMarker$str(), (Object)indexName);
    }

    protected String unableToCreateCurrentMarker$str() {
        return unableToCreateCurrentMarker;
    }

    @Override
    public final void unableToSynchronizeSource(String indexName, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unableToSynchronizeSource$str(), (Object)indexName);
    }

    protected String unableToSynchronizeSource$str() {
        return unableToSynchronizeSource;
    }

    @Override
    public final void unableToDetermineCurrentInSourceDirectory() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToDetermineCurrentInSourceDirectory$str(), new Object[0]);
    }

    protected String unableToDetermineCurrentInSourceDirectory$str() {
        return unableToDetermineCurrentInSourceDirectory;
    }

    @Override
    public final void unableToCompareSourceWithDestinationDirectory(String source, String destination) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unableToCompareSourceWithDestinationDirectory$str(), (Object)source, (Object)destination);
    }

    protected String unableToCompareSourceWithDestinationDirectory$str() {
        return unableToCompareSourceWithDestinationDirectory;
    }

    @Override
    public final void idCannotBeExtracted(String affectedOwnerEntityName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.idCannotBeExtracted$str(), (Object)affectedOwnerEntityName);
    }

    protected String idCannotBeExtracted$str() {
        return idCannotBeExtracted;
    }

    public final void serviceProviderNotReleased(Class class1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.serviceProviderNotReleased$str(), (Object)class1);
    }

    protected String serviceProviderNotReleased$str() {
        return serviceProviderNotReleased;
    }

    public final void stopServiceFailed(Class class1, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.stopServiceFailed$str(), (Object)class1);
    }

    protected String stopServiceFailed$str() {
        return stopServiceFailed;
    }

    @Override
    public final void indexingEntities(long count) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntities$str(), (Object)count);
    }

    protected String indexingEntities$str() {
        return indexingEntities;
    }

    @Override
    public final void indexingEntitiesCompleted(long nbrOfEntities) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntitiesCompleted$str(), (Object)nbrOfEntities);
    }

    protected String indexingEntitiesCompleted$str() {
        return indexingEntitiesCompleted;
    }

    @Override
    public final void indexingCompletedAndMBeanUnregistered(long nbrOfEntities) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingCompletedAndMBeanUnregistered$str(), (Object)nbrOfEntities);
    }

    protected String indexingCompletedAndMBeanUnregistered$str() {
        return indexingCompletedAndMBeanUnregistered;
    }

    @Override
    public final void indexingDocumentsCompleted(long doneCount, long elapsedMs) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingDocumentsCompleted$str(), (Object)doneCount, (Object)elapsedMs);
    }

    protected String indexingDocumentsCompleted$str() {
        return indexingDocumentsCompleted;
    }

    @Override
    public final void indexingSpeed(float estimateSpeed, float estimatePercentileComplete) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingSpeed$str(), (Object)Float.valueOf(estimateSpeed), (Object)Float.valueOf(estimatePercentileComplete));
    }

    protected String indexingSpeed$str() {
        return indexingSpeed;
    }

    @Override
    public final void notDeleted(File file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.notDeleted$str(), (Object)file);
    }

    protected String notDeleted$str() {
        return notDeleted;
    }

    @Override
    public final void notChangeTimestamp(File destFile) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.notChangeTimestamp$str(), (Object)destFile);
    }

    protected String notChangeTimestamp$str() {
        return notChangeTimestamp;
    }

    @Override
    public final void version(String versionString) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.version$str(), (Object)versionString);
    }

    protected String version$str() {
        return version;
    }

    @Override
    public final void couldNotCloseResource(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.couldNotCloseResource$str(), new Object[0]);
    }

    protected String couldNotCloseResource$str() {
        return couldNotCloseResource;
    }

    @Override
    public final void cannotGuessTransactionStatus(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.cannotGuessTransactionStatus$str(), new Object[0]);
    }

    protected String cannotGuessTransactionStatus$str() {
        return cannotGuessTransactionStatus;
    }

    @Override
    public final void unableToCloseSearcherDuringQuery(String query, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseSearcherDuringQuery$str(), (Object)query);
    }

    protected String unableToCloseSearcherDuringQuery$str() {
        return unableToCloseSearcherDuringQuery;
    }

    @Override
    public final void forceToUseDocumentExtraction() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.forceToUseDocumentExtraction$str(), new Object[0]);
    }

    protected String forceToUseDocumentExtraction$str() {
        return forceToUseDocumentExtraction;
    }

    @Override
    public final void unableToCloseSearcherInScrollableResult(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseSearcherInScrollableResult$str(), new Object[0]);
    }

    protected String unableToCloseSearcherInScrollableResult$str() {
        return unableToCloseSearcherInScrollableResult;
    }

    @Override
    public final void unexpectedValueMissingFromFieldCache() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unexpectedValueMissingFromFieldCache$str(), new Object[0]);
    }

    protected String unexpectedValueMissingFromFieldCache$str() {
        return unexpectedValueMissingFromFieldCache;
    }

    @Override
    public final void indexDirectoryNotFoundCreatingNewOne(String absolutePath) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexDirectoryNotFoundCreatingNewOne$str(), (Object)absolutePath);
    }

    protected String indexDirectoryNotFoundCreatingNewOne$str() {
        return indexDirectoryNotFoundCreatingNewOne;
    }

    @Override
    public final void noCurrentMarkerInSourceDirectory() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noCurrentMarkerInSourceDirectory$str(), new Object[0]);
    }

    protected String noCurrentMarkerInSourceDirectory$str() {
        return noCurrentMarkerInSourceDirectory;
    }

    @Override
    public final void foundCurrentMarker() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.foundCurrentMarker$str(), new Object[0]);
    }

    protected String foundCurrentMarker$str() {
        return foundCurrentMarker;
    }

    @Override
    public final void abstractClassesCannotInsertDocuments(String clazz) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.abstractClassesCannotInsertDocuments$str(), (Object)clazz);
    }

    protected String abstractClassesCannotInsertDocuments$str() {
        return abstractClassesCannotInsertDocuments;
    }

    public final void containedInPointsToProvidedId(Class objectClass) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.containedInPointsToProvidedId$str(), (Object)objectClass);
    }

    protected String containedInPointsToProvidedId$str() {
        return containedInPointsToProvidedId;
    }

    public final void cannotExtractValueForIdentifier(Class beanClass) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotExtractValueForIdentifier$str(), (Object)beanClass);
    }

    protected String cannotExtractValueForIdentifier$str() {
        return cannotExtractValueForIdentifier;
    }

    @Override
    public final void unableToCloseJmsConnection(String jmsQueueName, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseJmsConnection$str(), (Object)jmsQueueName);
    }

    protected String unableToCloseJmsConnection$str() {
        return unableToCloseJmsConnection;
    }

    @Override
    public final void unableToRetrieveNamedAnalyzer(String value) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToRetrieveNamedAnalyzer$str(), (Object)value);
    }

    protected String unableToRetrieveNamedAnalyzer$str() {
        return unableToRetrieveNamedAnalyzer;
    }

    @Override
    public final void interruptedWhileWaitingForIndexActivity(InterruptedException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.interruptedWhileWaitingForIndexActivity$str(), new Object[0]);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }

    @Override
    public final void pushedChangesOutOfTransaction() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.pushedChangesOutOfTransaction$str(), new Object[0]);
    }

    protected String pushedChangesOutOfTransaction$str() {
        return pushedChangesOutOfTransaction;
    }

    @Override
    public final void forcingReleaseIndexWriterLock() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.forcingReleaseIndexWriterLock$str(), new Object[0]);
    }

    protected String forcingReleaseIndexWriterLock$str() {
        return forcingReleaseIndexWriterLock;
    }

    @Override
    public final void checkSizeMustBePositive() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.checkSizeMustBePositive$str(), new Object[0]);
    }

    protected String checkSizeMustBePositive$str() {
        return checkSizeMustBePositive;
    }

    @Override
    public final void readersNotProperlyClosedInReaderProvider() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.readersNotProperlyClosedInReaderProvider$str(), new Object[0]);
    }

    protected String readersNotProperlyClosedInReaderProvider$str() {
        return readersNotProperlyClosedInReaderProvider;
    }

    @Override
    public final void unableToCloseLuceneIndexReader(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseLuceneIndexReader$str(), new Object[0]);
    }

    protected String unableToCloseLuceneIndexReader$str() {
        return unableToCloseLuceneIndexReader;
    }

    @Override
    public final void unableToUnregisterExistingMBean(String name, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToUnregisterExistingMBean$str(), (Object)name);
    }

    protected String unableToUnregisterExistingMBean$str() {
        return unableToUnregisterExistingMBean;
    }

    @Override
    public final void exceptionOccurred(String errorMsg, Throwable exceptionThatOccurred) {
        this.log.logf(FQCN, Logger.Level.ERROR, exceptionThatOccurred, this.exceptionOccurred$str(), (Object)errorMsg);
    }

    protected String exceptionOccurred$str() {
        return exceptionOccurred;
    }

    @Override
    public final void workerException(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.workerException$str(), new Object[0]);
    }

    protected String workerException$str() {
        return workerException;
    }

    @Override
    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }

    @Override
    public final void errorRollingBackTransaction(String message, Exception e1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e1, this.errorRollingBackTransaction$str(), (Object)message);
    }

    protected String errorRollingBackTransaction$str() {
        return errorRollingBackTransaction;
    }

    @Override
    public final void failedSlaveDirectoryProviderInitialization(String indexName, Exception re) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)re, this.failedSlaveDirectoryProviderInitialization$str(), (Object)indexName);
    }

    protected String failedSlaveDirectoryProviderInitialization$str() {
        return failedSlaveDirectoryProviderInitialization;
    }

    @Override
    public final void unableToCloseLuceneDirectory(Object directory, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unableToCloseLuceneDirectory$str(), directory);
    }

    protected String unableToCloseLuceneDirectory$str() {
        return unableToCloseLuceneDirectory;
    }

    public final void unableToRetrieveObjectFromMessage(Class messageClass, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unableToRetrieveObjectFromMessage$str(), (Object)messageClass);
    }

    protected String unableToRetrieveObjectFromMessage$str() {
        return unableToRetrieveObjectFromMessage;
    }

    @Override
    public final void illegalObjectRetrievedFromMessage(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.illegalObjectRetrievedFromMessage$str(), new Object[0]);
    }

    protected String illegalObjectRetrievedFromMessage$str() {
        return illegalObjectRetrievedFromMessage;
    }

    @Override
    public final void cannotOpenIndexWriterCausePreviousError() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotOpenIndexWriterCausePreviousError$str(), new Object[0]);
    }

    protected String cannotOpenIndexWriterCausePreviousError$str() {
        return cannotOpenIndexWriterCausePreviousError;
    }

    @Override
    public final void backendError(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.backendError$str(), new Object[0]);
    }

    protected String backendError$str() {
        return backendError;
    }

    @Override
    public final void recommendConfiguringLuceneVersion() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.recommendConfiguringLuceneVersion$str(), new Object[0]);
    }

    protected String recommendConfiguringLuceneVersion$str() {
        return recommendConfiguringLuceneVersion;
    }

    @Override
    public final SearchException cantOpenCorruptedIndex(CorruptIndexException e, String indexName) {
        SearchException result = new SearchException(String.format(this.cantOpenCorruptedIndex$str(), indexName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cantOpenCorruptedIndex$str() {
        return cantOpenCorruptedIndex;
    }

    @Override
    public final SearchException ioExceptionOnIndex(IOException e, String indexName) {
        SearchException result = new SearchException(String.format(this.ioExceptionOnIndex$str(), indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioExceptionOnIndex$str() {
        return ioExceptionOnIndex;
    }

    @Override
    public final void unableToShutdownAsynchronousIndexingByTimeout(String indexName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unableToShutdownAsynchronousIndexingByTimeout$str(), (Object)indexName);
    }

    protected String unableToShutdownAsynchronousIndexingByTimeout$str() {
        return unableToShutdownAsynchronousIndexingByTimeout;
    }

    @Override
    public final void serializationProtocol(int major, int minor) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.serializationProtocol$str(), (Object)major, (Object)minor);
    }

    protected String serializationProtocol$str() {
        return serializationProtocol;
    }

    @Override
    public final void messageReceivedForUndefinedIndex(String indexName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.messageReceivedForUndefinedIndex$str(), (Object)indexName);
    }

    protected String messageReceivedForUndefinedIndex$str() {
        return messageReceivedForUndefinedIndex;
    }

    @Override
    public final void warnSuspiciousBackendDirectoryCombination(String indexName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnSuspiciousBackendDirectoryCombination$str(), (Object)indexName);
    }

    protected String warnSuspiciousBackendDirectoryCombination$str() {
        return warnSuspiciousBackendDirectoryCombination;
    }

    @Override
    public final SearchException unableToSerializeLuceneWorks(Throwable e) {
        SearchException result = new SearchException(String.format(this.unableToSerializeLuceneWorks$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSerializeLuceneWorks$str() {
        return unableToSerializeLuceneWorks;
    }

    @Override
    public final SearchException unableToReadSerializedLuceneWorks(Throwable e) {
        SearchException result = new SearchException(String.format(this.unableToReadSerializedLuceneWorks$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadSerializedLuceneWorks$str() {
        return unableToReadSerializedLuceneWorks;
    }

    public final SearchException attributeNotRecognizedNorSerializable(Class attributeType) {
        SearchException result = new SearchException(String.format(this.attributeNotRecognizedNorSerializable$str(), attributeType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributeNotRecognizedNorSerializable$str() {
        return attributeNotRecognizedNorSerializable;
    }

    @Override
    public final SearchException unknownAttributeSerializedRepresentation(String name) {
        SearchException result = new SearchException(String.format(this.unknownAttributeSerializedRepresentation$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAttributeSerializedRepresentation$str() {
        return unknownAttributeSerializedRepresentation;
    }

    @Override
    public final SearchException unableToReadTokenStream() {
        SearchException result = new SearchException(String.format(this.unableToReadTokenStream$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadTokenStream$str() {
        return unableToReadTokenStream;
    }

    @Override
    public final SearchException unableToConvertSerializableTermVectorToLuceneTermVector(String termVector) {
        SearchException result = new SearchException(String.format(this.unableToConvertSerializableTermVectorToLuceneTermVector$str(), termVector));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertSerializableTermVectorToLuceneTermVector$str() {
        return unableToConvertSerializableTermVectorToLuceneTermVector;
    }

    @Override
    public final SearchException unableToConvertSerializableIndexToLuceneIndex(String index) {
        SearchException result = new SearchException(String.format(this.unableToConvertSerializableIndexToLuceneIndex$str(), index));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertSerializableIndexToLuceneIndex$str() {
        return unableToConvertSerializableIndexToLuceneIndex;
    }

    @Override
    public final SearchException unableToConvertSerializableStoreToLuceneStore(String store) {
        SearchException result = new SearchException(String.format(this.unableToConvertSerializableStoreToLuceneStore$str(), store));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertSerializableStoreToLuceneStore$str() {
        return unableToConvertSerializableStoreToLuceneStore;
    }

    @Override
    public final SearchException unknownNumericFieldType(String dataType) {
        SearchException result = new SearchException(String.format(this.unknownNumericFieldType$str(), dataType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownNumericFieldType$str() {
        return unknownNumericFieldType;
    }

    @Override
    public final SearchException conversionFromReaderToStringNotYetImplemented() {
        SearchException result = new SearchException(String.format(this.conversionFromReaderToStringNotYetImplemented$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conversionFromReaderToStringNotYetImplemented$str() {
        return conversionFromReaderToStringNotYetImplemented;
    }

    public final SearchException unknownFieldType(Class fieldType) {
        SearchException result = new SearchException(String.format(this.unknownFieldType$str(), fieldType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldType$str() {
        return unknownFieldType;
    }

    public final SearchException cannotSerializeCustomField(Class fieldType) {
        SearchException result = new SearchException(String.format(this.cannotSerializeCustomField$str(), fieldType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotSerializeCustomField$str() {
        return cannotSerializeCustomField;
    }

    public final SearchException failToSerializeObject(Class type, Throwable e) {
        SearchException result = new SearchException(String.format(this.failToSerializeObject$str(), type), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToSerializeObject$str() {
        return failToSerializeObject;
    }

    @Override
    public final SearchException failToDeserializeObject(Throwable e) {
        SearchException result = new SearchException(String.format(this.failToDeserializeObject$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToDeserializeObject$str() {
        return failToDeserializeObject;
    }

    @Override
    public final SearchException incompatibleProtocolVersion(int messageMajor, int messageMinor, int currentMajor, int currentMinor) {
        SearchException result = new SearchException(String.format(this.incompatibleProtocolVersion$str(), messageMajor, messageMinor, currentMajor, currentMinor));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompatibleProtocolVersion$str() {
        return incompatibleProtocolVersion;
    }

    @Override
    public final SearchException unableToDeserializeAvroStream(Throwable e) {
        SearchException result = new SearchException(String.format(this.unableToDeserializeAvroStream$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDeserializeAvroStream$str() {
        return unableToDeserializeAvroStream;
    }

    @Override
    public final SearchException cannotDeserializeOperation(String schema) {
        SearchException result = new SearchException(String.format(this.cannotDeserializeOperation$str(), schema));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeserializeOperation$str() {
        return cannotDeserializeOperation;
    }

    @Override
    public final SearchException cannotDeserializeField(String schema) {
        SearchException result = new SearchException(String.format(this.cannotDeserializeField$str(), schema));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeserializeField$str() {
        return cannotDeserializeField;
    }

    @Override
    public final SearchException unableToSerializeInAvro(Throwable e) {
        SearchException result = new SearchException(String.format(this.unableToSerializeInAvro$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSerializeInAvro$str() {
        return unableToSerializeInAvro;
    }

    @Override
    public final SearchException unableToInitializeIndexManager(String indexName, Throwable e) {
        SearchException result = new SearchException(String.format(this.unableToInitializeIndexManager$str(), indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitializeIndexManager$str() {
        return unableToInitializeIndexManager;
    }

    @Override
    public final void ignoringBackendOptionForIndex(String indexName, String forcedBackend) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringBackendOptionForIndex$str(), (Object)indexName, (Object)forcedBackend);
    }

    protected String ignoringBackendOptionForIndex$str() {
        return ignoringBackendOptionForIndex;
    }

    @Override
    public final SearchException cannotGetResultSizeWithCriteriaAndRestriction(String criteria) {
        SearchException result = new SearchException(String.format(this.cannotGetResultSizeWithCriteriaAndRestriction$str(), criteria));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotGetResultSizeWithCriteriaAndRestriction$str() {
        return cannotGetResultSizeWithCriteriaAndRestriction;
    }

    @Override
    public final SearchException fieldLooksBinaryButDecompressionFailed(String fieldName) {
        SearchException result = new SearchException(String.format(this.fieldLooksBinaryButDecompressionFailed$str(), fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldLooksBinaryButDecompressionFailed$str() {
        return fieldLooksBinaryButDecompressionFailed;
    }

    @Override
    public final SearchException requestedIndexNotDefined(String indexName) {
        SearchException result = new SearchException(String.format(this.requestedIndexNotDefined$str(), indexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requestedIndexNotDefined$str() {
        return requestedIndexNotDefined;
    }

    @Override
    public final void shuttingDownBackend(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.shuttingDownBackend$str(), (Object)indexName);
    }

    protected String shuttingDownBackend$str() {
        return shuttingDownBackend;
    }

    @Override
    public final IllegalArgumentException notAnIndexedType(String entityName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.notAnIndexedType$str(), entityName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notAnIndexedType$str() {
        return notAnIndexedType;
    }

    @Override
    public final IllegalArgumentException nullIsInvalidIndexedType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullIsInvalidIndexedType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullIsInvalidIndexedType$str() {
        return nullIsInvalidIndexedType;
    }

    @Override
    public final IllegalArgumentException needAtLeastOneIndexName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.needAtLeastOneIndexName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needAtLeastOneIndexName$str() {
        return needAtLeastOneIndexName;
    }

    @Override
    public final IllegalArgumentException needAtLeastOneIndexedEntityType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.needAtLeastOneIndexedEntityType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needAtLeastOneIndexedEntityType$str() {
        return needAtLeastOneIndexedEntityType;
    }

    @Override
    public final IllegalArgumentException nullIsInvalidIndexName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullIsInvalidIndexName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullIsInvalidIndexName$str() {
        return nullIsInvalidIndexName;
    }

    @Override
    public final SearchException unableToLoadResource(String fileName) {
        SearchException result = new SearchException(String.format(this.unableToLoadResource$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadResource$str() {
        return unableToLoadResource;
    }

    @Override
    public final SearchException unknownFullTextFilter(String filterName) {
        SearchException result = new SearchException(String.format(this.unknownFullTextFilter$str(), filterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFullTextFilter$str() {
        return unknownFullTextFilter;
    }

    @Override
    public final String massIndexerUnexpectedErrorMessage() {
        String result = String.format(this.massIndexerUnexpectedErrorMessage$str(), new Object[0]);
        return result;
    }

    protected String massIndexerUnexpectedErrorMessage$str() {
        return massIndexerUnexpectedErrorMessage;
    }

    @Override
    public final String ioExceptionOnIndexWriter() {
        String result = String.format(this.ioExceptionOnIndexWriter$str(), new Object[0]);
        return result;
    }

    protected String ioExceptionOnIndexWriter$str() {
        return ioExceptionOnIndexWriter;
    }

    @Override
    public final String exceptionDuringIndexMergeOperation() {
        String result = String.format(this.exceptionDuringIndexMergeOperation$str(), new Object[0]);
        return result;
    }

    protected String exceptionDuringIndexMergeOperation$str() {
        return exceptionDuringIndexMergeOperation;
    }

    @Override
    public final void optimizationSkippedStillBusy(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.optimizationSkippedStillBusy$str(), (Object)indexName);
    }

    protected String optimizationSkippedStillBusy$str() {
        return optimizationSkippedStillBusy;
    }

    @Override
    public final void inconsistentFieldConfiguration(String className, String fieldName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.inconsistentFieldConfiguration$str(), (Object)className, (Object)fieldName);
    }

    protected String inconsistentFieldConfiguration$str() {
        return inconsistentFieldConfiguration;
    }

    public final void forceSkipIndexOperationViaInterception(Class entityClass, WorkType type) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.forceSkipIndexOperationViaInterception$str(), (Object)entityClass, (Object)type);
    }

    protected String forceSkipIndexOperationViaInterception$str() {
        return forceSkipIndexOperationViaInterception;
    }

    public final void forceRemoveOnIndexOperationViaInterception(Class entityClass, WorkType type) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.forceRemoveOnIndexOperationViaInterception$str(), (Object)entityClass, (Object)type);
    }

    protected String forceRemoveOnIndexOperationViaInterception$str() {
        return forceRemoveOnIndexOperationViaInterception;
    }

    public final void forceUpdateOnIndexOperationViaInterception(Class entityClass, WorkType type) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.forceUpdateOnIndexOperationViaInterception$str(), (Object)entityClass, (Object)type);
    }

    protected String forceUpdateOnIndexOperationViaInterception$str() {
        return forceUpdateOnIndexOperationViaInterception;
    }

    @Override
    public final SearchException targetedFieldNotSpatial(String className, String fieldName) {
        SearchException result = new SearchException(String.format(this.targetedFieldNotSpatial$str(), className, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String targetedFieldNotSpatial$str() {
        return targetedFieldNotSpatial;
    }

    @Override
    public final SearchException noFieldBridgeInterfaceImplementedByClassBridge(String implName) {
        SearchException result = new SearchException(String.format(this.noFieldBridgeInterfaceImplementedByClassBridge$str(), implName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldBridgeInterfaceImplementedByClassBridge$str() {
        return noFieldBridgeInterfaceImplementedByClassBridge;
    }

    @Override
    public final SearchException cannotInstantiateClassBridgeOfType(String implName, String className, Throwable e) {
        SearchException result = new SearchException(String.format(this.cannotInstantiateClassBridgeOfType$str(), implName, className), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInstantiateClassBridgeOfType$str() {
        return cannotInstantiateClassBridgeOfType;
    }

    @Override
    public final SearchException unableToGuessFieldBridge(String className, String fieldName) {
        SearchException result = new SearchException(String.format(this.unableToGuessFieldBridge$str(), className, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToGuessFieldBridge$str() {
        return unableToGuessFieldBridge;
    }

    @Override
    public final SearchException unableToInstantiateSpatial(String className, Throwable e) {
        SearchException result = new SearchException(String.format(this.unableToInstantiateSpatial$str(), className), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateSpatial$str() {
        return unableToInstantiateSpatial;
    }

    @Override
    public final SearchException noImplementationClassInFieldBridge(String className) {
        SearchException result = new SearchException(String.format(this.noImplementationClassInFieldBridge$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noImplementationClassInFieldBridge$str() {
        return noImplementationClassInFieldBridge;
    }

    @Override
    public final SearchException noFieldBridgeInterfaceImplementedByFieldBridge(String implName, String appliedOnName) {
        SearchException result = new SearchException(String.format(this.noFieldBridgeInterfaceImplementedByFieldBridge$str(), implName, appliedOnName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldBridgeInterfaceImplementedByFieldBridge$str() {
        return noFieldBridgeInterfaceImplementedByFieldBridge;
    }

    @Override
    public final SearchException unableToInstantiateFieldBridge(String appliedOnName, String appliedOnTypeName, Throwable e) {
        SearchException result = new SearchException(String.format(this.unableToInstantiateFieldBridge$str(), appliedOnName, appliedOnTypeName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateFieldBridge$str() {
        return unableToInstantiateFieldBridge;
    }

    @Override
    public final AssertionFailure unknownResolution(String resolution) {
        AssertionFailure result = new AssertionFailure(String.format(this.unknownResolution$str(), resolution));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownResolution$str() {
        return unknownResolution;
    }

    @Override
    public final SearchException fieldBridgeNotAnInstanceof(String className) {
        SearchException result = new SearchException(String.format(this.fieldBridgeNotAnInstanceof$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldBridgeNotAnInstanceof$str() {
        return fieldBridgeNotAnInstanceof;
    }

    @Override
    public final EmptyQueryException queryWithNoTermsAfterAnalysis(String field, String searchTerm) {
        EmptyQueryException result = new EmptyQueryException(String.format(this.queryWithNoTermsAfterAnalysis$str(), field, searchTerm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryWithNoTermsAfterAnalysis$str() {
        return queryWithNoTermsAfterAnalysis;
    }

    @Override
    public final SearchException unableToDetermineClassBridge(String className) {
        SearchException result = new SearchException(String.format(this.unableToDetermineClassBridge$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDetermineClassBridge$str() {
        return unableToDetermineClassBridge;
    }

    @Override
    public final SearchException unableToGetInputStreamFromBlob(Throwable e) {
        SearchException result = new SearchException(String.format(this.unableToGetInputStreamFromBlob$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToGetInputStreamFromBlob$str() {
        return unableToGetInputStreamFromBlob;
    }

    public final SearchException unsupportedTikaBridgeType(Class objectType) {
        SearchException result = new SearchException(String.format(this.unsupportedTikaBridgeType$str(), objectType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedTikaBridgeType$str() {
        return unsupportedTikaBridgeType;
    }

    @Override
    public final SearchException fileDoesNotExist(String fileName) {
        SearchException result = new SearchException(String.format(this.fileDoesNotExist$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileDoesNotExist$str() {
        return fileDoesNotExist;
    }

    @Override
    public final SearchException fileIsADirectory(String fileName) {
        SearchException result = new SearchException(String.format(this.fileIsADirectory$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileIsADirectory$str() {
        return fileIsADirectory;
    }

    @Override
    public final SearchException fileIsNotReadable(String fileName) {
        SearchException result = new SearchException(String.format(this.fileIsNotReadable$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileIsNotReadable$str() {
        return fileIsNotReadable;
    }

    @Override
    public final SearchException unableToConfigureTikaBridge(String bridgeName, Throwable e) {
        SearchException result = new SearchException(String.format(this.unableToConfigureTikaBridge$str(), bridgeName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConfigureTikaBridge$str() {
        return unableToConfigureTikaBridge;
    }

    @Override
    public final SearchException cannotReadFieldForClass(String fieldName, String className) {
        SearchException result = new SearchException(String.format(this.cannotReadFieldForClass$str(), fieldName, className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotReadFieldForClass$str() {
        return cannotReadFieldForClass;
    }

    @Override
    public final SearchException cannotExtractCoordinateFromObject(String className) {
        SearchException result = new SearchException(String.format(this.cannotExtractCoordinateFromObject$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotExtractCoordinateFromObject$str() {
        return cannotExtractCoordinateFromObject;
    }

    @Override
    public final SearchException cannotHaveTwoSpatialsWithDefaultOrSameName(String className) {
        SearchException result = new SearchException(String.format(this.cannotHaveTwoSpatialsWithDefaultOrSameName$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotHaveTwoSpatialsWithDefaultOrSameName$str() {
        return cannotHaveTwoSpatialsWithDefaultOrSameName;
    }

    @Override
    public final SearchException cannotFindCoordinatesNorLatLongForSpatial(String spatialName, String className) {
        SearchException result = new SearchException(String.format(this.cannotFindCoordinatesNorLatLongForSpatial$str(), spatialName, className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindCoordinatesNorLatLongForSpatial$str() {
        return cannotFindCoordinatesNorLatLongForSpatial;
    }

    @Override
    public final SearchException ambiguousLatitudeDefinition(String beanXClassName, String firstField, String secondField) {
        SearchException result = new SearchException(String.format(this.ambiguousLatitudeDefinition$str(), beanXClassName, firstField, secondField));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambiguousLatitudeDefinition$str() {
        return ambiguousLatitudeDefinition;
    }

    @Override
    public final SearchException ambiguousLongitudeDefinition(String beanXClassName, String firstField, String secondField) {
        SearchException result = new SearchException(String.format(this.ambiguousLongitudeDefinition$str(), beanXClassName, firstField, secondField));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambiguousLongitudeDefinition$str() {
        return ambiguousLongitudeDefinition;
    }

    @Override
    public final SearchException unableToOpenJMSConnection(String indexName, String jmsQueueName, Throwable e) {
        SearchException result = new SearchException(String.format(this.unableToOpenJMSConnection$str(), indexName, jmsQueueName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToOpenJMSConnection$str() {
        return unableToOpenJMSConnection;
    }

    @Override
    public final SearchException unableToSendJMSWork(String indexName, String jmsQueueName, Throwable e) {
        SearchException result = new SearchException(String.format(this.unableToSendJMSWork$str(), indexName, jmsQueueName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSendJMSWork$str() {
        return unableToSendJMSWork;
    }

    @Override
    public final SearchException jmsQueueLookupException(String jmsQueueName, String indexName, Throwable e) {
        SearchException result = new SearchException(String.format(this.jmsQueueLookupException$str(), jmsQueueName, indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jmsQueueLookupException$str() {
        return jmsQueueLookupException;
    }

    @Override
    public final void indexManagerAliasResolved(String alias, Class im) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.indexManagerAliasResolved$str(), (Object)alias, (Object)im);
    }

    protected String indexManagerAliasResolved$str() {
        return indexManagerAliasResolved;
    }

    @Override
    public final SearchException duplicateDocumentIdFound(String beanXClassName) {
        SearchException result = new SearchException(String.format(this.duplicateDocumentIdFound$str(), beanXClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateDocumentIdFound$str() {
        return duplicateDocumentIdFound;
    }

    @Override
    public final void indexManagerUsesSerializationService(String indexName, String serializerDescription) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexManagerUsesSerializationService$str(), (Object)indexName, (Object)serializerDescription);
    }

    protected String indexManagerUsesSerializationService$str() {
        return indexManagerUsesSerializationService;
    }

    public final SearchException fieldBridgeNotTwoWay(Class bridgeClass, String fieldName, XClass beanXClass) {
        SearchException result = new SearchException(String.format(this.fieldBridgeNotTwoWay$str(), bridgeClass, fieldName, beanXClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldBridgeNotTwoWay$str() {
        return fieldBridgeNotTwoWay;
    }

    @Override
    public final SearchException unableToParseDocument(Throwable cause) {
        SearchException result = new SearchException(String.format(this.unableToParseDocument$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToParseDocument$str() {
        return unableToParseDocument;
    }

    @Override
    public final SearchException noDocumentIdFoundException(String entityName) {
        SearchException result = new SearchException(String.format(this.noDocumentIdFoundException$str(), entityName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDocumentIdFoundException$str() {
        return noDocumentIdFoundException;
    }

    @Override
    public final IllegalArgumentException getNullSessionPassedToFullTextSessionCreationException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getNullSessionPassedToFullTextSessionCreationException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNullSessionPassedToFullTextSessionCreationException$str() {
        return getNullSessionPassedToFullTextSessionCreationException;
    }

    @Override
    public final IllegalArgumentException getNullSessionPassedToFullEntityManagerCreationException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getNullSessionPassedToFullEntityManagerCreationException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNullSessionPassedToFullEntityManagerCreationException$str() {
        return getNullSessionPassedToFullEntityManagerCreationException;
    }

    @Override
    public final ClassCastException getUnableToNarrowFieldDescriptorException(String actualDescriptorType, String type, String expectedType) {
        ClassCastException result = new ClassCastException(String.format(this.getUnableToNarrowFieldDescriptorException$str(), actualDescriptorType, type, expectedType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToNarrowFieldDescriptorException$str() {
        return getUnableToNarrowFieldDescriptorException;
    }

    @Override
    public final IllegalArgumentException getPropertyNameCannotBeNullException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getPropertyNameCannotBeNullException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getPropertyNameCannotBeNullException$str() {
        return getPropertyNameCannotBeNullException;
    }

    @Override
    public final IllegalArgumentException getFieldNameCannotBeNullException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getFieldNameCannotBeNullException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getFieldNameCannotBeNullException$str() {
        return getFieldNameCannotBeNullException;
    }

    @Override
    public final String massIndexerUnableToIndexInstance(String clazz, String value) {
        String result = String.format(this.massIndexerUnableToIndexInstance$str(), clazz, value);
        return result;
    }

    protected String massIndexerUnableToIndexInstance$str() {
        return massIndexerUnableToIndexInstance;
    }

    public final SearchException entityWithNoShard(Class type) {
        SearchException result = new SearchException(String.format(this.entityWithNoShard$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String entityWithNoShard$str() {
        return entityWithNoShard;
    }

    public final SearchException assertionFailureCannotCastToWorkerBuilderContext(Class type) {
        SearchException result = new SearchException(String.format(this.assertionFailureCannotCastToWorkerBuilderContext$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String assertionFailureCannotCastToWorkerBuilderContext$str() {
        return assertionFailureCannotCastToWorkerBuilderContext;
    }

    @Override
    public final SearchException getMultipleEntitiesShareIndexWithInconsistentSimilarityException(String class1, String similarity1, String class2, String similarity2) {
        SearchException result = new SearchException(String.format(this.getMultipleEntitiesShareIndexWithInconsistentSimilarityException$str(), class1, similarity1, class2, similarity2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMultipleEntitiesShareIndexWithInconsistentSimilarityException$str() {
        return getMultipleEntitiesShareIndexWithInconsistentSimilarityException;
    }

    @Override
    public final SearchException getNoSessionFactoryInContextException() {
        SearchException result = new SearchException(String.format(this.getNoSessionFactoryInContextException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNoSessionFactoryInContextException$str() {
        return getNoSessionFactoryInContextException;
    }

    @Override
    public final SearchException getInvalidShardCountException(int value) {
        SearchException result = new SearchException(String.format(this.getInvalidShardCountException$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidShardCountException$str() {
        return getInvalidShardCountException;
    }

    @Override
    public final SearchException getInvalidIntegerValueException(String msg, Throwable throwable) {
        SearchException result = new SearchException(String.format(this.getInvalidIntegerValueException$str(), msg), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidIntegerValueException$str() {
        return getInvalidIntegerValueException;
    }

    @Override
    public final void idHashShardingWithSingleShard() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.idHashShardingWithSingleShard$str(), new Object[0]);
    }

    protected String idHashShardingWithSingleShard$str() {
        return idHashShardingWithSingleShard;
    }

    @Override
    public final SearchException getUnableToLoadShardingStrategyClassException(String className) {
        SearchException result = new SearchException(String.format(this.getUnableToLoadShardingStrategyClassException$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToLoadShardingStrategyClassException$str() {
        return getUnableToLoadShardingStrategyClassException;
    }

    @Override
    public final SearchException getMultipleServiceImplementationsException(String service, String foundServices) {
        SearchException result = new SearchException(String.format(this.getMultipleServiceImplementationsException$str(), service, foundServices));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMultipleServiceImplementationsException$str() {
        return getMultipleServiceImplementationsException;
    }

    @Override
    public final SearchException getNoServiceImplementationFoundException(String service) {
        SearchException result = new SearchException(String.format(this.getNoServiceImplementationFoundException$str(), service));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNoServiceImplementationFoundException$str() {
        return getNoServiceImplementationFoundException;
    }

    @Override
    public final SearchException getUnableToCreateJGroupsBackendException(Throwable throwable) {
        SearchException result = new SearchException(String.format(this.getUnableToCreateJGroupsBackendException$str(), new Object[0]), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToCreateJGroupsBackendException$str() {
        return getUnableToCreateJGroupsBackendException;
    }

    @Override
    public final SearchException getUnexpectedServiceStatusException(String status, String service) {
        SearchException result = new SearchException(String.format(this.getUnexpectedServiceStatusException$str(), status, service));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnexpectedServiceStatusException$str() {
        return getUnexpectedServiceStatusException;
    }

    @Override
    public final SearchException configurationPropertyCantBeEmpty(String key) {
        SearchException result = new SearchException(String.format(this.configurationPropertyCantBeEmpty$str(), key));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configurationPropertyCantBeEmpty$str() {
        return configurationPropertyCantBeEmpty;
    }

    @Override
    public final SearchException incorrectEditDistance() {
        SearchException result = new SearchException(String.format(this.incorrectEditDistance$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incorrectEditDistance$str() {
        return incorrectEditDistance;
    }

    public final SearchException entityWithIdNotFound(Class entityType, String id) {
        SearchException result = new SearchException(String.format(this.entityWithIdNotFound$str(), entityType, id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String entityWithIdNotFound$str() {
        return entityWithIdNotFound;
    }

    public final SearchException noFieldCompatibleForMoreLikeThis(Class entityType) {
        SearchException result = new SearchException(String.format(this.noFieldCompatibleForMoreLikeThis$str(), entityType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldCompatibleForMoreLikeThis$str() {
        return noFieldCompatibleForMoreLikeThis;
    }

    public final SearchException ioExceptionOnIndexOfEntity(IOException e, Class entityType) {
        SearchException result = new SearchException(String.format(this.ioExceptionOnIndexOfEntity$str(), entityType), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioExceptionOnIndexOfEntity$str() {
        return ioExceptionOnIndexOfEntity;
    }

    public final SearchException requireTFIDFSimilarity(Class beanClass) {
        SearchException result = new SearchException(String.format(this.requireTFIDFSimilarity$str(), beanClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requireTFIDFSimilarity$str() {
        return requireTFIDFSimilarity;
    }

    public final SearchException fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis(String fieldName, Class entityType) {
        SearchException result = new SearchException(String.format(this.fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis$str(), fieldName, entityType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis$str() {
        return fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis;
    }

    @Override
    public final SearchException classLoaderServiceContainedInProvidedServicesException() {
        SearchException result = new SearchException(String.format(this.classLoaderServiceContainedInProvidedServicesException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String classLoaderServiceContainedInProvidedServicesException$str() {
        return classLoaderServiceContainedInProvidedServicesException;
    }

    @Override
    public final IllegalStateException serviceRequestedAfterReleasedAllWasCalled() {
        IllegalStateException result = new IllegalStateException(String.format(this.serviceRequestedAfterReleasedAllWasCalled$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serviceRequestedAfterReleasedAllWasCalled$str() {
        return serviceRequestedAfterReleasedAllWasCalled;
    }

    @Override
    public final SearchException providedServicesCannotImplementStartableOrStoppable(String service, String implementedInterface) {
        SearchException result = new SearchException(String.format(this.providedServicesCannotImplementStartableOrStoppable$str(), service, implementedInterface));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String providedServicesCannotImplementStartableOrStoppable$str() {
        return providedServicesCannotImplementStartableOrStoppable;
    }

    @Override
    public final String massIndexerExceptionWhileFetchingIds() {
        String result = String.format(this.massIndexerExceptionWhileFetchingIds$str(), new Object[0]);
        return result;
    }

    protected String massIndexerExceptionWhileFetchingIds$str() {
        return massIndexerExceptionWhileFetchingIds;
    }

    @Override
    public final String massIndexerExceptionWhileTransformingIds() {
        String result = String.format(this.massIndexerExceptionWhileTransformingIds$str(), new Object[0]);
        return result;
    }

    protected String massIndexerExceptionWhileTransformingIds$str() {
        return massIndexerExceptionWhileTransformingIds;
    }

    public final SearchException fieldIdCannotBeUsedInMoreLikeThis(String fieldName, Class entityType) {
        SearchException result = new SearchException(String.format(this.fieldIdCannotBeUsedInMoreLikeThis$str(), fieldName, entityType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldIdCannotBeUsedInMoreLikeThis$str() {
        return fieldIdCannotBeUsedInMoreLikeThis;
    }

    public final SearchException numericFieldCannotBeUsedInMoreLikeThis(String fieldName, Class entityType) {
        SearchException result = new SearchException(String.format(this.numericFieldCannotBeUsedInMoreLikeThis$str(), fieldName, entityType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String numericFieldCannotBeUsedInMoreLikeThis$str() {
        return numericFieldCannotBeUsedInMoreLikeThis;
    }

    @Override
    public final SearchException multipleMatchingFieldBridges(XMember member, XClass memberType, String listOfFieldBridges) {
        SearchException result = new SearchException(String.format(this.multipleMatchingFieldBridges$str(), member, memberType, listOfFieldBridges));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleMatchingFieldBridges$str() {
        return multipleMatchingFieldBridges;
    }

    @Override
    public final SearchException invalidIncludePathConfiguration(String member, String clazz, String invalidPaths) {
        SearchException result = new SearchException(String.format(this.invalidIncludePathConfiguration$str(), member, clazz, invalidPaths));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidIncludePathConfiguration$str() {
        return invalidIncludePathConfiguration;
    }

    @Override
    public final SearchException invalidPropertyValue(String value, String property) {
        SearchException result = new SearchException(String.format(this.invalidPropertyValue$str(), value, property));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPropertyValue$str() {
        return invalidPropertyValue;
    }

    @Override
    public final SearchException unknownFieldNameForMoreLikeThisQuery(String field, String type) {
        SearchException result = new SearchException(String.format(this.unknownFieldNameForMoreLikeThisQuery$str(), field, type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldNameForMoreLikeThisQuery$str() {
        return unknownFieldNameForMoreLikeThisQuery;
    }

    @Override
    public final SearchException jmsInitialContextException(String jmsConnectionFactoryName, String indexName, Exception e) {
        SearchException result = new SearchException(String.format(this.jmsInitialContextException$str(), jmsConnectionFactoryName, indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jmsInitialContextException$str() {
        return jmsInitialContextException;
    }

    @Override
    public final SearchException jmsQueueFactoryLookupException(String jmsConnectionFactoryName, String indexName, Exception e) {
        SearchException result = new SearchException(String.format(this.jmsQueueFactoryLookupException$str(), jmsConnectionFactoryName, indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jmsQueueFactoryLookupException$str() {
        return jmsQueueFactoryLookupException;
    }

    @Override
    public final SearchException detectInfiniteTypeLoopInIndexedEmbedded(String elementClass, String rootEntity, String path) {
        SearchException result = new SearchException(String.format(this.detectInfiniteTypeLoopInIndexedEmbedded$str(), elementClass, rootEntity, path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String detectInfiniteTypeLoopInIndexedEmbedded$str() {
        return detectInfiniteTypeLoopInIndexedEmbedded;
    }

    @Override
    public final SearchException searchFactoryNotInitialized() {
        SearchException result = new SearchException(String.format(this.searchFactoryNotInitialized$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String searchFactoryNotInitialized$str() {
        return searchFactoryNotInitialized;
    }

    @Override
    public final SearchException searchFactoryReferenceServiceNotFound() {
        SearchException result = new SearchException(String.format(this.searchFactoryReferenceServiceNotFound$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String searchFactoryReferenceServiceNotFound$str() {
        return searchFactoryReferenceServiceNotFound;
    }

    @Override
    public final AssertionFailure parametersShouldNotBeNull(String parameterName) {
        AssertionFailure result = new AssertionFailure(String.format(this.parametersShouldNotBeNull$str(), parameterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String parametersShouldNotBeNull$str() {
        return parametersShouldNotBeNull;
    }

    @Override
    public final void lockingFailureDuringInitialization(String directoryDescription) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.lockingFailureDuringInitialization$str(), (Object)directoryDescription);
    }

    protected String lockingFailureDuringInitialization$str() {
        return lockingFailureDuringInitialization;
    }

    @Override
    public final void logInfoStreamMessage(String componentName, String message) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.logInfoStreamMessage$str(), (Object)componentName, (Object)message);
    }

    protected String logInfoStreamMessage$str() {
        return logInfoStreamMessage;
    }

    @Override
    public final SearchException booleanQueryWithoutClauses() {
        SearchException result = new SearchException(String.format(this.booleanQueryWithoutClauses$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String booleanQueryWithoutClauses$str() {
        return booleanQueryWithoutClauses;
    }
}

