/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.List;
import java.util.concurrent.locks.LockSupport;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;

final class Changeset {
    private final List<LuceneWork> workList;
    private final Thread producer;
    private final IndexingMonitor monitor;
    private volatile boolean processed = false;

    Changeset(List<LuceneWork> workList, Thread producer, IndexingMonitor monitor) {
        this.workList = workList;
        this.producer = producer;
        this.monitor = monitor;
    }

    List<LuceneWork> getWorkList() {
        return this.workList;
    }

    IndexingMonitor getMonitor() {
        return this.monitor;
    }

    boolean isProcessed() {
        return this.processed;
    }

    public void markProcessed() {
        this.processed = true;
        LockSupport.unpark(this.producer);
    }
}

