/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;

public class SpatialNumericDocValueField
extends Field {
    public static final FieldType TYPE = SpatialNumericDocValueField.createSpatialFieldType();

    private static FieldType createSpatialFieldType() {
        FieldType type = new FieldType();
        type.setIndexed(false);
        type.setDocValueType(FieldInfo.DocValuesType.NUMERIC);
        type.freeze();
        return type;
    }

    public SpatialNumericDocValueField(String name, Double value) {
        super(name, TYPE);
        this.fieldsData = Double.doubleToRawLongBits(value);
    }

    public void setDoubleValue(double value) {
        super.setLongValue(Double.doubleToRawLongBits(value));
    }

    public void setLongValue(long value) {
        throw new IllegalArgumentException("cannot change value type from Double to Long");
    }
}

