/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.bridge.AppliedOnTypeAwareBridge;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.impl.BuiltinArrayBridge;
import org.hibernate.search.bridge.builtin.impl.BuiltinIterableBridge;
import org.hibernate.search.bridge.builtin.impl.BuiltinMapBridge;
import org.hibernate.search.bridge.builtin.impl.String2FieldBridgeAdaptor;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.impl.BasicJDKTypesBridgeProvider;
import org.hibernate.search.bridge.impl.CalendarBridgeProvider;
import org.hibernate.search.bridge.impl.DateBridgeProvider;
import org.hibernate.search.bridge.impl.EnumBridgeProvider;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;
import org.hibernate.search.bridge.impl.JavaTimeBridgeProvider;
import org.hibernate.search.bridge.impl.NumericBridgeProvider;
import org.hibernate.search.bridge.impl.SpatialBridgeProvider;
import org.hibernate.search.bridge.impl.TikaBridgeProvider;
import org.hibernate.search.bridge.impl.XMemberBridgeProviderContext;
import org.hibernate.search.bridge.spi.BridgeProvider;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class BridgeFactory {
    private static final Log LOG = LoggerFactory.make();
    private final Set<BridgeProvider> annotationBasedProviders = new HashSet<BridgeProvider>(5);
    private final Set<BridgeProvider> regularProviders = new HashSet<BridgeProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BridgeFactory(ServiceManager serviceManager) {
        this.annotationBasedProviders.add(new CalendarBridgeProvider());
        this.annotationBasedProviders.add(new DateBridgeProvider());
        this.annotationBasedProviders.add(new NumericBridgeProvider());
        this.annotationBasedProviders.add(new SpatialBridgeProvider());
        this.annotationBasedProviders.add(new TikaBridgeProvider());
        ClassLoaderService classLoaderService = serviceManager.requestService(ClassLoaderService.class);
        try {
            this.provideJavaTimeBridges(classLoaderService);
            for (BridgeProvider provider : classLoaderService.loadJavaServices(BridgeProvider.class)) {
                this.regularProviders.add(provider);
            }
        }
        finally {
            serviceManager.releaseService(ClassLoaderService.class);
        }
        this.regularProviders.add(new EnumBridgeProvider());
        this.regularProviders.add(new BasicJDKTypesBridgeProvider(serviceManager));
    }

    private void provideJavaTimeBridges(ClassLoaderService classLoaderService) {
        JavaTimeBridgeProvider javaTimeBridgeProvider = new JavaTimeBridgeProvider(classLoaderService);
        if (javaTimeBridgeProvider.hasFoundSomeJavaTimeTypes()) {
            this.annotationBasedProviders.add(javaTimeBridgeProvider);
        }
    }

    public FieldBridge extractType(ClassBridge cb, Class<?> clazz) {
        Class<?> bridgeType;
        FieldBridge bridge;
        block7: {
            bridge = null;
            bridgeType = null;
            if (cb != null && (bridgeType = cb.impl()) != null) {
                try {
                    Object instance = bridgeType.newInstance();
                    if (FieldBridge.class.isAssignableFrom(bridgeType)) {
                        bridge = (FieldBridge)instance;
                        break block7;
                    }
                    if (TwoWayStringBridge.class.isAssignableFrom(bridgeType)) {
                        bridge = new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)instance);
                        break block7;
                    }
                    if (StringBridge.class.isAssignableFrom(bridgeType)) {
                        bridge = new String2FieldBridgeAdaptor((StringBridge)instance);
                        break block7;
                    }
                    throw LOG.noFieldBridgeInterfaceImplementedByClassBridge(bridgeType.getName());
                }
                catch (Exception e) {
                    throw LOG.cannotInstantiateClassBridgeOfType(bridgeType.getName(), clazz.getName(), e);
                }
            }
        }
        if (bridge == null) {
            throw LOG.unableToDetermineClassBridge(ClassBridge.class.getName());
        }
        this.populateReturnType(clazz, bridgeType, bridge);
        return bridge;
    }

    public void injectParameters(ClassBridge classBridgeConfiguration, Object classBridge) {
        if (classBridgeConfiguration.params().length > 0 && ParameterizedBridge.class.isAssignableFrom(classBridge.getClass())) {
            HashMap<String, String> params = new HashMap<String, String>(classBridgeConfiguration.params().length);
            for (Parameter param : classBridgeConfiguration.params()) {
                params.put(param.name(), param.value());
            }
            ((ParameterizedBridge)classBridge).setParameterValues(params);
        }
    }

    public FieldBridge buildSpatialBridge(Spatial spatial, XClass clazz, String latitudeField, String longitudeField) {
        FieldBridge bridge;
        try {
            bridge = SpatialBridgeProvider.buildSpatialBridge(spatial, latitudeField, longitudeField);
        }
        catch (Exception e) {
            throw LOG.unableToInstantiateSpatial(clazz.getName(), e);
        }
        if (bridge == null) {
            throw LOG.unableToInstantiateSpatial(clazz.getName(), null);
        }
        return bridge;
    }

    public FieldBridge buildFieldBridge(XMember member, boolean isId, ReflectionManager reflectionManager, ServiceManager serviceManager) {
        return this.buildFieldBridge(null, member, isId, reflectionManager, serviceManager);
    }

    public FieldBridge buildFieldBridge(Field field, XMember member, boolean isId, ReflectionManager reflectionManager, ServiceManager serviceManager) {
        FieldBridge bridge = this.findExplicitFieldBridge(field, member, reflectionManager);
        if (bridge != null) {
            return bridge;
        }
        XMemberBridgeProviderContext context = new XMemberBridgeProviderContext(member, isId, reflectionManager, serviceManager);
        ContainerType containerType = this.getContainerType(member, reflectionManager);
        for (BridgeProvider provider : this.annotationBasedProviders) {
            bridge = this.getFieldBridgeFromBridgeProvider(provider, context, containerType);
            if (bridge == null) continue;
            return bridge;
        }
        StringBuilder multipleMatchError = null;
        BridgeProvider initialMatchingBridgeProvider = null;
        for (BridgeProvider provider : this.regularProviders) {
            FieldBridge createdBridge = this.getFieldBridgeFromBridgeProvider(provider, context, containerType);
            if (createdBridge == null) continue;
            if (bridge != null) {
                if (multipleMatchError == null) {
                    multipleMatchError = new StringBuilder("\n").append("FieldBridge: ").append(bridge).append(" - BridgeProvider: ").append(initialMatchingBridgeProvider.getClass());
                }
                multipleMatchError.append("\n").append("FieldBridge: ").append(createdBridge).append(" - BridgeProvider: ").append(provider.getClass());
                continue;
            }
            bridge = createdBridge;
            initialMatchingBridgeProvider = provider;
        }
        if (multipleMatchError != null) {
            throw LOG.multipleMatchingFieldBridges(member, member.getType(), multipleMatchError.toString());
        }
        if (bridge != null) {
            return bridge;
        }
        throw LOG.unableToGuessFieldBridge(member.getType().getName(), member.getName());
    }

    private ContainerType getContainerType(XMember member, ReflectionManager reflectionManager) {
        if (!member.isAnnotationPresent(IndexedEmbedded.class)) {
            return ContainerType.SINGLE;
        }
        if (member.isArray()) {
            return ContainerType.ARRAY;
        }
        Class typeClass = reflectionManager.toClass(member.getType());
        if (Iterable.class.isAssignableFrom(typeClass)) {
            return ContainerType.ITERABLE;
        }
        if (member.isCollection() && Map.class.equals((Object)member.getCollectionClass())) {
            return ContainerType.MAP;
        }
        return ContainerType.SINGLE;
    }

    private FieldBridge getFieldBridgeFromBridgeProvider(BridgeProvider bridgeProvider, ExtendedBridgeProvider.ExtendedBridgeProviderContext context, ContainerType containerType) {
        FieldBridge bridge = bridgeProvider.provideFieldBridge(context);
        if (bridge == null) {
            return null;
        }
        this.populateReturnType(context.getReturnType(), bridge.getClass(), bridge);
        switch (containerType) {
            case SINGLE: {
                return bridge;
            }
            case ITERABLE: {
                return new BuiltinIterableBridge(bridge);
            }
            case ARRAY: {
                return new BuiltinArrayBridge(bridge);
            }
            case MAP: {
                return new BuiltinMapBridge(bridge);
            }
        }
        throw new AssertionFailure("Unknown ContainerType " + (Object)((Object)containerType));
    }

    private FieldBridge findExplicitFieldBridge(Field field, XMember member, ReflectionManager reflectionManager) {
        FieldBridge bridge = null;
        org.hibernate.search.annotations.FieldBridge bridgeAnnotation = field != null && Void.TYPE != field.bridge().impl() ? field.bridge() : (org.hibernate.search.annotations.FieldBridge)member.getAnnotation(org.hibernate.search.annotations.FieldBridge.class);
        if (bridgeAnnotation != null) {
            bridge = this.createFieldBridgeFromAnnotation(bridgeAnnotation, member.getName(), reflectionManager.toClass(member.getType()));
        }
        return bridge;
    }

    private FieldBridge createFieldBridgeFromAnnotation(org.hibernate.search.annotations.FieldBridge bridgeAnn, String appliedOnName, Class<?> appliedOnType) {
        FieldBridge bridge;
        if (bridgeAnn == null) {
            throw new AssertionFailure("@FieldBridge instance cannot be null");
        }
        Class<?> fieldBridgeClass = bridgeAnn.impl();
        if (fieldBridgeClass == Void.TYPE) {
            throw LOG.noImplementationClassInFieldBridge(appliedOnName);
        }
        try {
            Object instance = ReflectionHelper.createInstance(fieldBridgeClass, true);
            if (FieldBridge.class.isAssignableFrom(fieldBridgeClass)) {
                bridge = (FieldBridge)instance;
            } else if (TwoWayStringBridge.class.isAssignableFrom(fieldBridgeClass)) {
                bridge = new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)instance);
            } else if (StringBridge.class.isAssignableFrom(fieldBridgeClass)) {
                bridge = new String2FieldBridgeAdaptor((StringBridge)instance);
            } else {
                throw LOG.noFieldBridgeInterfaceImplementedByFieldBridge(fieldBridgeClass.getName(), appliedOnName);
            }
            if (bridgeAnn.params().length > 0 && ParameterizedBridge.class.isAssignableFrom(fieldBridgeClass)) {
                HashMap<String, String> params = new HashMap<String, String>(bridgeAnn.params().length);
                for (Parameter param : bridgeAnn.params()) {
                    params.put(param.name(), param.value());
                }
                ((ParameterizedBridge)instance).setParameterValues(params);
            }
            this.populateReturnType(appliedOnType, fieldBridgeClass, instance);
        }
        catch (Exception e) {
            throw LOG.unableToInstantiateFieldBridge(appliedOnName, appliedOnType.getName(), e);
        }
        return bridge;
    }

    private void populateReturnType(Class<?> appliedOnType, Class<?> bridgeType, Object bridgeInstance) {
        if (AppliedOnTypeAwareBridge.class.isAssignableFrom(bridgeType)) {
            ((AppliedOnTypeAwareBridge)bridgeInstance).setAppliedOnType(appliedOnType);
        }
    }

    public TwoWayFieldBridge extractTwoWayType(org.hibernate.search.annotations.FieldBridge fieldBridge, XClass appliedOnType, ReflectionManager reflectionManager) {
        FieldBridge fb = this.extractType(fieldBridge, appliedOnType, reflectionManager);
        if (fb instanceof TwoWayFieldBridge) {
            return (TwoWayFieldBridge)fb;
        }
        throw LOG.fieldBridgeNotAnInstanceof(TwoWayFieldBridge.class.getSimpleName());
    }

    private FieldBridge extractType(org.hibernate.search.annotations.FieldBridge fieldBridgeAnnotation, XClass appliedOnType, ReflectionManager reflectionManager) {
        FieldBridge bridge = null;
        if (fieldBridgeAnnotation != null) {
            bridge = this.createFieldBridgeFromAnnotation(fieldBridgeAnnotation, appliedOnType.getName(), reflectionManager.toClass(appliedOnType));
        }
        if (bridge == null) {
            throw LOG.unableToDetermineClassBridge(appliedOnType.getName());
        }
        return bridge;
    }

    private static enum ContainerType {
        SINGLE,
        ARRAY,
        ITERABLE,
        MAP;

    }
}

