/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.jgroups.impl.JGroupsBackendQueueTask;
import org.hibernate.search.backend.jgroups.impl.MessageSenderService;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorService;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorStrategy;
import org.hibernate.search.backend.jgroups.logging.impl.Log;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Address;

public class JGroupsBackendQueueProcessor
implements BackendQueueProcessor {
    private static final String JGROUPS_CONFIGURATION_SPACE = "jgroups";
    public static final String BLOCK_WAITING_ACK = "block_waiting_ack";
    public static final String DELEGATE_BACKEND = "delegate_backend";
    public static final String MESSAGE_TIMEOUT_MS = "messages_timeout";
    public static final int DEFAULT_MESSAGE_TIMEOUT = 20000;
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private final NodeSelectorStrategy selectionStrategy;
    protected MessageSenderService messageSender;
    protected String indexName;
    protected IndexManager indexManager;
    private Address address;
    private ServiceManager serviceManager;
    private JGroupsBackendQueueTask jgroupsProcessor;
    private BackendQueueProcessor delegatedBackend;

    public JGroupsBackendQueueProcessor(NodeSelectorStrategy selectionStrategy) {
        this.selectionStrategy = selectionStrategy;
    }

    public void initialize(Properties props, WorkerBuildContext context, IndexManager indexManager) {
        this.indexManager = indexManager;
        this.indexName = indexManager.getIndexName();
        JGroupsBackendQueueProcessor.assertLegacyOptionsNotUsed(props, this.indexName);
        this.serviceManager = context.getServiceManager();
        this.messageSender = (MessageSenderService)this.serviceManager.requestService(MessageSenderService.class);
        NodeSelectorService masterNodeSelector = (NodeSelectorService)this.serviceManager.requestService(NodeSelectorService.class);
        masterNodeSelector.setNodeSelectorStrategy(this.indexName, this.selectionStrategy);
        this.selectionStrategy.viewAccepted(this.messageSender.getView());
        boolean sync = BackendFactory.isConfiguredAsSync((Properties)props);
        MaskedProperty jgroupsProperties = new MaskedProperty(props, JGROUPS_CONFIGURATION_SPACE);
        boolean block = ConfigurationParseHelper.getBooleanValue((Properties)jgroupsProperties, (String)BLOCK_WAITING_ACK, (boolean)sync);
        long messageTimeout = ConfigurationParseHelper.getLongValue((Properties)jgroupsProperties, (String)MESSAGE_TIMEOUT_MS, (long)20000L);
        log.jgroupsBlockWaitingForAck(this.indexName, block);
        this.jgroupsProcessor = new JGroupsBackendQueueTask(this, indexManager, masterNodeSelector, block, messageTimeout);
        if (this.selectionStrategy.isIndexOwnerLocal()) {
            String backend = ConfigurationParseHelper.getString((Properties)jgroupsProperties, (String)DELEGATE_BACKEND, null);
            this.delegatedBackend = BackendFactory.createBackend((String)backend, (IndexManager)indexManager, (WorkerBuildContext)context, (Properties)props);
        }
    }

    public void close() {
        this.serviceManager.releaseService(NodeSelectorService.class);
        this.serviceManager.releaseService(MessageSenderService.class);
        if (this.selectionStrategy.isIndexOwnerLocal()) {
            this.delegatedBackend.close();
        }
    }

    MessageSenderService getMessageSenderService() {
        return this.messageSender;
    }

    public Address getAddress() {
        if (this.address == null && this.messageSender != null) {
            this.address = this.messageSender.getAddress();
        }
        return this.address;
    }

    public void indexMappingChanged() {
    }

    public void closeIndexWriter() {
        if (this.selectionStrategy.isIndexOwnerLocal()) {
            this.delegatedBackend.closeIndexWriter();
        } else {
            log.debugf("Not owning the index '%s' so ignoring request to release IndexWriter lock", this.indexName);
        }
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (this.selectionStrategy.isIndexOwnerLocal()) {
            this.delegatedBackend.applyWork(workList, monitor);
        } else {
            if (workList == null) {
                throw new IllegalArgumentException("workList should not be null");
            }
            this.jgroupsProcessor.sendLuceneWorkList(workList);
        }
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        if (this.selectionStrategy.isIndexOwnerLocal()) {
            this.delegatedBackend.applyStreamWork(singleOperation, monitor);
        } else {
            this.jgroupsProcessor.sendLuceneWorkList(Collections.singletonList(singleOperation));
        }
    }

    public Lock getExclusiveWriteLock() {
        return this.delegatedBackend.getExclusiveWriteLock();
    }

    private static void assertLegacyOptionsNotUsed(Properties props, String indexName) {
        MaskedProperty jgroupsCfg = new MaskedProperty(props, "worker.backend.jgroups");
        if (jgroupsCfg.containsKey((Object)"configurationFile") || jgroupsCfg.containsKey((Object)"configurationXml") || jgroupsCfg.containsKey((Object)"configurationString") || jgroupsCfg.containsKey((Object)"clusterName")) {
            throw log.legacyJGroupsConfigurationDefined(indexName);
        }
    }

    public boolean blocksForACK() {
        return this.jgroupsProcessor.blocksForACK();
    }

    public BackendQueueProcessor getDelegatedBackend() {
        return this.delegatedBackend;
    }

    public long getMessageTimeout() {
        return this.jgroupsProcessor.getMessageTimeout();
    }
}

