/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;

public class ElasticsearchBridgeProvider
extends ExtendedBridgeProvider {
    public FieldBridge provideFieldBridge(ExtendedBridgeProvider.ExtendedBridgeProviderContext bridgeContext) {
        if (this.isDate(bridgeContext.getReturnType())) {
            return EsDateBridge.INSTANCE;
        }
        return null;
    }

    private boolean isDate(Class<?> clazz) {
        return "java.util.Date".equals(clazz.getName());
    }

    private static class EsDateBridge
    implements TwoWayFieldBridge {
        private static EsDateBridge INSTANCE = new EsDateBridge();

        private EsDateBridge() {
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            if (value == null) {
                return;
            }
            luceneOptions.addFieldToDocument(name, this.convertToString((Date)value), document);
        }

        public Object get(String name, Document document) {
            Calendar c = DatatypeConverter.parseDateTime((String)document.get(name));
            return c.getTime();
        }

        public String objectToString(Object object) {
            return this.convertToString((Date)object);
        }

        private String convertToString(Date value) {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
            c.setTime(value);
            return DatatypeConverter.printDateTime((Calendar)c);
        }
    }
}

