/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.config.idle;

import com.google.common.util.concurrent.AbstractScheduledService;
import io.searchbox.client.config.ClientConfig;
import io.searchbox.client.config.idle.ReapableConnectionManager;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleConnectionReaper
extends AbstractScheduledService {
    static final Logger logger = LoggerFactory.getLogger(IdleConnectionReaper.class);
    private final ReapableConnectionManager reapableConnectionManager;
    private final ClientConfig clientConfig;

    public IdleConnectionReaper(ClientConfig clientConfig, ReapableConnectionManager reapableConnectionManager) {
        this.reapableConnectionManager = reapableConnectionManager;
        this.clientConfig = clientConfig;
    }

    protected void runOneIteration() throws Exception {
        logger.debug("closing idle connections...");
        this.reapableConnectionManager.closeIdleConnections(this.clientConfig.getMaxConnectionIdleTime(), this.clientConfig.getMaxConnectionIdleTimeDurationTimeUnit());
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)this.clientConfig.getMaxConnectionIdleTime(), (TimeUnit)this.clientConfig.getMaxConnectionIdleTimeDurationTimeUnit());
    }
}

