/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.searchbox.action.AbstractAction;
import io.searchbox.cluster.Health;
import io.searchbox.indices.CloseIndex;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.DeleteIndex;
import io.searchbox.indices.IndicesExists;
import io.searchbox.indices.OpenIndex;
import io.searchbox.indices.mapping.GetMapping;
import io.searchbox.indices.mapping.PutMapping;
import io.searchbox.indices.settings.GetSettings;
import io.searchbox.indices.settings.UpdateSettings;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import org.hibernate.search.elasticsearch.client.impl.JestClient;
import org.hibernate.search.elasticsearch.impl.GsonService;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexMetadata;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.elasticsearch.settings.impl.model.IndexSettings;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchSchemaAccessor
implements Service,
Startable,
Stoppable {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final TypeToken<Map<String, TypeMapping>> STRING_TO_TYPE_MAPPING_MAP_TYPE_TOKEN = new TypeToken<Map<String, TypeMapping>>(){};
    private ServiceManager serviceManager;
    private JestClient jestClient;
    private GsonService gsonService;

    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.jestClient = (JestClient)this.serviceManager.requestService(JestClient.class);
        this.gsonService = (GsonService)this.serviceManager.requestService(GsonService.class);
    }

    public void stop() {
        this.jestClient = null;
        this.serviceManager.releaseService(JestClient.class);
        this.gsonService = null;
        this.serviceManager.releaseService(GsonService.class);
        this.serviceManager = null;
    }

    private String serializeAsJsonWithoutNulls(Object object) {
        Gson gson = this.gsonService.getGsonNoSerializeNulls();
        return gson.toJson(object);
    }

    public void createIndex(String indexName, IndexSettings settings, ExecutionOptions executionOptions) {
        String settingsAsJson = settings == null ? null : this.serializeAsJsonWithoutNulls(settings);
        CreateIndex createIndex = new CreateIndex.Builder(indexName).settings((Object)settingsAsJson).build();
        this.jestClient.executeRequest(createIndex);
    }

    public boolean createIndexIfAbsent(String indexName, IndexSettings settings, ExecutionOptions executionOptions) {
        String settingsAsJson = settings == null ? null : this.serializeAsJsonWithoutNulls(settings);
        CreateIndex createIndex = new CreateIndex.Builder(indexName).settings((Object)settingsAsJson).build();
        Object result = this.jestClient.executeRequest(createIndex, new String[]{"index_already_exists_exception"});
        return result.isSucceeded();
    }

    public boolean indexExists(String indexName) {
        Object peekResult = this.jestClient.executeRequest(new IndicesExists.Builder(indexName).build(), new int[]{404});
        return peekResult.getResponseCode() == 200;
    }

    public IndexMetadata getCurrentIndexMetadata(String indexName) {
        IndexMetadata indexMetadata = new IndexMetadata();
        indexMetadata.setName(indexName);
        GetMapping getMapping = ((GetMapping.Builder)new GetMapping.Builder().addIndex(indexName)).build();
        try {
            Object result = this.jestClient.executeRequest(getMapping);
            JsonObject resultJson = result.getJsonObject();
            JsonElement index = result.getJsonObject().get(indexName);
            if (index == null || !index.isJsonObject()) {
                throw new AssertionFailure("Elasticsearch API call succeeded, but the requested index wasn't mentioned in the result: " + resultJson);
            }
            JsonElement mappings = index.getAsJsonObject().get("mappings");
            if (mappings != null) {
                Type mapType = STRING_TO_TYPE_MAPPING_MAP_TYPE_TOKEN.getType();
                indexMetadata.setMappings((Map)this.gsonService.getGson().fromJson(mappings, mapType));
            }
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchMappingRetrievalForValidationFailed(e);
        }
        GetSettings getSettings = ((GetSettings.Builder)new GetSettings.Builder().addIndex(indexName)).build();
        try {
            Object result = this.jestClient.executeRequest(getSettings);
            JsonObject resultJson = result.getJsonObject();
            JsonElement index = result.getJsonObject().get(indexName);
            if (index == null || !index.isJsonObject()) {
                throw new AssertionFailure("Elasticsearch API call succeeded, but the requested index wasn't mentioned in the result: " + resultJson);
            }
            JsonElement settings = index.getAsJsonObject().get("settings");
            if (settings == null || !settings.isJsonObject()) {
                throw new AssertionFailure("Elasticsearch API call succeeded, but the requested settings weren't mentioned in the result: " + resultJson);
            }
            JsonElement indexSettings = settings.getAsJsonObject().get("index");
            if (indexSettings != null) {
                indexMetadata.setSettings((IndexSettings)this.gsonService.getGson().fromJson(indexSettings, IndexSettings.class));
            } else {
                indexMetadata.setSettings(new IndexSettings());
            }
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchIndexSettingsRetrievalForValidationFailed(e);
        }
        return indexMetadata;
    }

    public void updateSettings(String indexName, IndexSettings settings) {
        String settingsAsJson = this.serializeAsJsonWithoutNulls(settings);
        UpdateSettings putSettings = ((UpdateSettings.Builder)new UpdateSettings.Builder((Object)settingsAsJson).addIndex(indexName)).build();
        try {
            this.jestClient.executeRequest(putSettings);
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchSettingsUpdateFailed(indexName, e);
        }
    }

    public void putMapping(String indexName, String mappingName, TypeMapping mapping) {
        String mappingAsJson = this.serializeAsJsonWithoutNulls(mapping);
        PutMapping putMapping = new PutMapping.Builder(indexName, mappingName, (Object)mappingAsJson).build();
        try {
            this.jestClient.executeRequest(putMapping);
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchMappingCreationFailed(mappingName, e);
        }
    }

    public void waitForIndexStatus(final String theIndexName, ExecutionOptions executionOptions) {
        String requiredIndexStatusString = executionOptions.getRequiredIndexStatus().getElasticsearchString();
        String timeoutAndUnit = executionOptions.getIndexManagementTimeoutInMs() + "ms";
        Health.Builder healthBuilder = (Health.Builder)((Health.Builder)new Health.Builder().setParameter("wait_for_status", (Object)requiredIndexStatusString)).setParameter("timeout", (Object)timeoutAndUnit);
        Health health = new Health(healthBuilder){

            protected String buildURI() {
                try {
                    return super.buildURI() + URLEncoder.encode(theIndexName, AbstractAction.CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionFailure("Unexpectedly unsupported charset", (Throwable)e);
                }
            }
        };
        Object result = this.jestClient.executeRequest(health, new int[]{408});
        if (!result.isSucceeded()) {
            String status = result.getJsonObject().get("status").getAsString();
            throw LOG.unexpectedIndexStatus(theIndexName, requiredIndexStatusString, status, timeoutAndUnit);
        }
    }

    public void dropIndex(String indexName, ExecutionOptions executionOptions) {
        this.jestClient.executeRequest(new DeleteIndex.Builder(indexName).build());
    }

    public void closeIndex(String indexName) {
        this.jestClient.executeRequest(new CloseIndex.Builder(indexName).build());
        LOG.closedIndex(indexName);
    }

    public void openIndex(String indexName) {
        try {
            this.jestClient.executeRequest(new OpenIndex.Builder(indexName).build());
        }
        catch (RuntimeException e) {
            LOG.openedIndex(indexName);
            throw e;
        }
        LOG.openedIndex(indexName);
    }
}

