/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.spi.IgnoreAnalyzerBridge;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class ElasticsearchTemporalAccessorStringBridge<T extends TemporalAccessor>
implements TwoWayStringBridge,
IgnoreAnalyzerBridge {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final DateTimeFormatter formatter;
    private final Class<T> type;

    ElasticsearchTemporalAccessorStringBridge(DateTimeFormatter formatter, Class<T> type) {
        this.formatter = formatter;
        this.type = type;
    }

    public String objectToString(Object object) {
        if (object == null) {
            return null;
        }
        String formatted = this.format(this.formatter, (TemporalAccessor)object);
        return formatted;
    }

    public Object stringToObject(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        try {
            return this.parse(this.formatter, stringValue);
        }
        catch (Exception e) {
            throw LOG.parseException(stringValue, this.type, e);
        }
    }

    String format(DateTimeFormatter formatter, T object) {
        return formatter.format((TemporalAccessor)object);
    }

    abstract T parse(DateTimeFormatter var1, String var2) throws Exception;
}

