/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl.nullencoding;

import org.hibernate.search.engine.impl.nullencoding.NullMarkerCodec;
import org.hibernate.search.engine.impl.nullencoding.NumericDoubleNullCodec;
import org.hibernate.search.engine.impl.nullencoding.NumericFloatNullCodec;
import org.hibernate.search.engine.impl.nullencoding.NumericIntegerNullCodec;
import org.hibernate.search.engine.impl.nullencoding.NumericLongNullCodec;
import org.hibernate.search.engine.metadata.impl.DocumentFieldPath;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class NumericNullEncodersHelper {
    private static final Log log = LoggerFactory.make();

    private NumericNullEncodersHelper() {
    }

    public static NullMarkerCodec createNumericNullMarkerCodec(NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType, String indexNullAs, DocumentFieldPath fieldPath) {
        String fieldName = fieldPath.getAbsoluteName();
        switch (numericEncodingType) {
            case DOUBLE: {
                return new NumericDoubleNullCodec(NumericNullEncodersHelper.toDouble(indexNullAs, fieldName));
            }
            case FLOAT: {
                return new NumericFloatNullCodec(NumericNullEncodersHelper.toFloat(indexNullAs, fieldName));
            }
            case INTEGER: {
                return new NumericIntegerNullCodec(NumericNullEncodersHelper.toInteger(indexNullAs, fieldName));
            }
            case LONG: {
                return new NumericLongNullCodec(NumericNullEncodersHelper.toLong(indexNullAs, fieldName));
            }
        }
        throw new AssertionFailure("this should never be invoked for non-Numeric fields");
    }

    private static Long toLong(String proposedTokenValue, String fieldName) {
        try {
            return Long.parseLong(proposedTokenValue);
        }
        catch (NumberFormatException nfe) {
            throw log.nullMarkerNeedsToRepresentALongNumber(proposedTokenValue, fieldName);
        }
    }

    private static Integer toInteger(String proposedTokenValue, String fieldName) {
        try {
            return Integer.parseInt(proposedTokenValue);
        }
        catch (NumberFormatException nfe) {
            throw log.nullMarkerNeedsToRepresentAnIntegerNumber(proposedTokenValue, fieldName);
        }
    }

    private static Float toFloat(String proposedTokenValue, String fieldName) {
        try {
            return Float.valueOf(Float.parseFloat(proposedTokenValue));
        }
        catch (NumberFormatException nfe) {
            throw log.nullMarkerNeedsToRepresentAFloatNumber(proposedTokenValue, fieldName);
        }
    }

    private static Double toDouble(String proposedTokenValue, String fieldName) {
        try {
            return Double.parseDouble(proposedTokenValue);
        }
        catch (NumberFormatException nfe) {
            throw log.nullMarkerNeedsToRepresentADoubleNumber(proposedTokenValue, fieldName);
        }
    }
}

