/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.QueueingProcessor;
import org.hibernate.search.backend.impl.TransactionalOperationDispatcher;
import org.hibernate.search.backend.impl.WorkQueue;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BatchedQueueingProcessor
implements QueueingProcessor {
    private static final Log log = LoggerFactory.make();
    private final int batchSize;
    private final TransactionalOperationDispatcher operationDispatcher;

    public BatchedQueueingProcessor(Map<Class<?>, EntityIndexBinding> entityIndexBindings, Properties properties, IndexManagerHolder indexManagerHolder) {
        this.batchSize = ConfigurationParseHelper.getIntValue(properties, "hibernate.search.batch_size", 0);
        this.operationDispatcher = new TransactionalOperationDispatcher(indexManagerHolder, entityIndexBindings);
    }

    @Override
    public void add(Work work, WorkQueue workQueue) {
        workQueue.add(work);
        if (this.batchSize > 0 && workQueue.size() >= this.batchSize) {
            WorkQueue subQueue = workQueue.splitQueue();
            this.prepareWorks(subQueue);
            this.performWorks(subQueue);
        }
    }

    @Override
    public void prepareWorks(WorkQueue workQueue) {
        workQueue.prepareWorkPlan();
    }

    @Override
    public void performWorks(WorkQueue workQueue) {
        List<LuceneWork> sealedQueue = workQueue.getSealedQueue();
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("Lucene WorkQueue to send to backends:[ \n\t");
            for (LuceneWork lw : sealedQueue) {
                sb.append(lw.toString());
                sb.append("\n\t");
            }
            if (sealedQueue.size() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]");
            log.trace(sb.toString());
        }
        this.operationDispatcher.dispatch(sealedQueue, null);
    }

    @Override
    public void cancelWorks(WorkQueue workQueue) {
        workQueue.clear();
    }
}

