/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.util.Properties;
import org.hibernate.search.engine.impl.DynamicShardingEntityIndexBinding;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.indexes.impl.DynamicShardingStrategy;
import org.hibernate.search.indexes.impl.EntityIndexBinder;
import org.hibernate.search.indexes.impl.IndexManagerGroupHolder;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.ShardIdentifierProvider;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.impl.ClassLoaderHelper;

class DynamicShardingEntityIndexBinder
implements EntityIndexBinder {
    private final Class<?> shardIdentifierProviderClass;
    private final Properties properties;

    public DynamicShardingEntityIndexBinder(Class<?> shardIdentifierProviderClass, Properties properties) {
        this.shardIdentifierProviderClass = shardIdentifierProviderClass;
        this.properties = properties;
    }

    @Override
    public MutableEntityIndexBinding bind(IndexManagerGroupHolder holder, Class<?> entityType, EntityIndexingInterceptor<?> interceptor, WorkerBuildContext buildContext) {
        MaskedProperty maskedProperties = new MaskedProperty(this.properties, "sharding_strategy");
        ShardIdentifierProvider shardIdentifierProvider = this.createShardIdentifierProvider(buildContext, maskedProperties);
        DynamicShardingStrategy shardingStrategy = new DynamicShardingStrategy(shardIdentifierProvider, holder, this.properties, entityType);
        this.preInitializeBackend(holder, buildContext);
        return new DynamicShardingEntityIndexBinding(holder, shardingStrategy, interceptor);
    }

    @Override
    public String createBackendIdentifier(String backendName, String indexName) {
        return backendName;
    }

    private ShardIdentifierProvider createShardIdentifierProvider(WorkerBuildContext buildContext, Properties indexProperty) {
        ShardIdentifierProvider shardIdentifierProvider = ClassLoaderHelper.instanceFromClass(ShardIdentifierProvider.class, this.shardIdentifierProviderClass, "ShardIdentifierProvider");
        shardIdentifierProvider.initialize(this.properties, buildContext);
        return shardIdentifierProvider;
    }

    private void preInitializeBackend(IndexManagerGroupHolder holder, WorkerBuildContext buildContext) {
        holder.getOrCreateBackend(holder.getIndexNameBase(), this.properties, buildContext);
    }
}

