/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.indexes.impl.IndexManagerGroupHolder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.ShardIdentifierProvider;

public class DynamicShardingStrategy
implements IndexShardingStrategy {
    private final ShardIdentifierProvider shardIdentifierProvider;
    private final IndexManagerGroupHolder indexManagerGroupHolder;
    private final Properties indexProperties;
    private final Class<?> entityType;

    public DynamicShardingStrategy(ShardIdentifierProvider shardIdentifierProvider, IndexManagerGroupHolder indexManagerGroupHolder, Properties indexProperties, Class<?> entityType) {
        this.shardIdentifierProvider = shardIdentifierProvider;
        this.indexManagerGroupHolder = indexManagerGroupHolder;
        this.indexProperties = indexProperties;
        this.entityType = entityType;
    }

    @Override
    public void initialize(Properties properties, IndexManager[] indexManagers) {
    }

    @Override
    public IndexManager[] getIndexManagersForAllShards() {
        Set<String> allShardIdentifiers = this.shardIdentifierProvider.getAllShardIdentifiers();
        return this.getIndexManagersFromShards(allShardIdentifiers);
    }

    @Override
    public IndexManager getIndexManagerForAddition(Class<?> entity, Serializable id, String idInString, Document document) {
        String shardIdentifier = this.shardIdentifierProvider.getShardIdentifier(entity, id, idInString, document);
        return this.indexManagerGroupHolder.getOrCreateIndexManager(shardIdentifier, this.indexProperties, this.entityType, null);
    }

    @Override
    public IndexManager[] getIndexManagersForDeletion(Class<?> entity, Serializable id, String idInString) {
        Set<String> shardIdentifiers = this.shardIdentifierProvider.getShardIdentifiersForDeletion(entity, id, idInString);
        return this.getIndexManagersFromShards(shardIdentifiers);
    }

    @Override
    public IndexManager[] getIndexManagersForQuery(FullTextFilterImplementor[] fullTextFilters) {
        Set<String> shards = this.shardIdentifierProvider.getShardIdentifiersForQuery(fullTextFilters);
        return this.getIndexManagersFromShards(shards);
    }

    public ShardIdentifierProvider getShardIdentifierProvider() {
        return this.shardIdentifierProvider;
    }

    private IndexManager[] getIndexManagersFromShards(Set<String> shardIdentifiers) {
        HashSet<IndexManager> managers = new HashSet<IndexManager>(shardIdentifiers.size());
        for (String shardIdentifier : shardIdentifiers) {
            managers.add(this.indexManagerGroupHolder.getOrCreateIndexManager(shardIdentifier, this.indexProperties, this.entityType, null));
        }
        return managers.toArray(new IndexManager[shardIdentifiers.size()]);
    }
}

