/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.util.Map;
import java.util.Objects;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzer;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalysisDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalyzerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.CharFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenizerDefinition;

public class CustomElasticsearchAnalyzerImpl
implements ElasticsearchAnalyzer {
    private final String analyzerName;
    private final AnalyzerDefinition analyzerDefinition;
    private final TokenizerDefinition tokenizerDefinition;
    private final Map<String, CharFilterDefinition> charFilters;
    private final Map<String, TokenFilterDefinition> tokenFilters;

    public CustomElasticsearchAnalyzerImpl(String analyzerName, AnalyzerDefinition analyzerDefinition, String tokenizerName, TokenizerDefinition tokenizerDefinition, Map<String, CharFilterDefinition> charFilters, Map<String, TokenFilterDefinition> tokenFilters) {
        this.analyzerName = analyzerName;
        this.analyzerDefinition = analyzerDefinition;
        this.tokenizerDefinition = tokenizerDefinition;
        this.charFilters = charFilters;
        this.tokenFilters = tokenFilters;
    }

    public String getName(String fieldName) {
        return this.analyzerName;
    }

    @Override
    public String registerDefinitions(ElasticsearchAnalysisDefinitionRegistry registry, String fieldName) {
        registry.register(this.analyzerName, this.analyzerDefinition);
        if (this.tokenizerDefinition != null) {
            registry.register(this.analyzerDefinition.getTokenizer(), this.tokenizerDefinition);
        }
        for (Map.Entry<String, CharFilterDefinition> entry : this.charFilters.entrySet()) {
            registry.register(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, AnalysisDefinition> entry : this.tokenFilters.entrySet()) {
            registry.register(entry.getKey(), (TokenFilterDefinition)entry.getValue());
        }
        return this.analyzerName;
    }

    public void close() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.analyzerName);
        result = 31 * result + Objects.hashCode(this.analyzerDefinition);
        result = 31 * result + Objects.hashCode(this.tokenizerDefinition);
        result = 31 * result + Objects.hashCode(this.charFilters);
        result = 31 * result + Objects.hashCode(this.tokenFilters);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CustomElasticsearchAnalyzerImpl) {
            CustomElasticsearchAnalyzerImpl other = (CustomElasticsearchAnalyzerImpl)obj;
            return Objects.equals(this.analyzerName, other.analyzerName) && Objects.equals(this.analyzerDefinition, other.analyzerDefinition) && Objects.equals(this.tokenizerDefinition, other.tokenizerDefinition) && Objects.equals(this.charFilters, other.charFilters) && Objects.equals(this.tokenFilters, other.tokenFilters);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        sb.append(this.analyzerName);
        sb.append(", ");
        sb.append(this.analyzerDefinition);
        sb.append(">");
        return sb.toString();
    }
}

