/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.Sniffer;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClientImplementor;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.dialect.impl.DialectIndependentGsonProvider;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.logging.impl.ElasticsearchLogCategories;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.util.logging.impl.LogCategory;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultElasticsearchClient
implements ElasticsearchClientImplementor {
    private static final Log requestLog = (Log)LoggerFactory.make(Log.class, (LogCategory)ElasticsearchLogCategories.REQUEST);
    private final RestClient restClient;
    private final Sniffer sniffer;
    private volatile GsonProvider gsonProvider;

    public DefaultElasticsearchClient(RestClient restClient, Sniffer sniffer) {
        this.restClient = restClient;
        this.sniffer = sniffer;
        this.gsonProvider = DialectIndependentGsonProvider.INSTANCE;
    }

    @Override
    public void init(GsonProvider gsonProvider) {
        this.gsonProvider = gsonProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute(ElasticsearchRequest request) throws IOException {
        Gson gson = this.gsonProvider.getGson();
        HttpEntity entity = ElasticsearchClientUtils.toEntity(gson, request);
        long start = System.nanoTime();
        try {
            Response response = this.restClient.performRequest(request.getMethod(), request.getPath(), request.getParameters(), entity, new Header[0]);
            return response;
        }
        catch (ResponseException e) {
            requestLog.debug("ES client issued a ResponseException - not necessarily a problem", e);
            Response response = e.getResponse();
            return response;
        }
        finally {
            long executionTime = System.nanoTime() - start;
            requestLog.executedRequest(request.getPath(), request.getParameters(), TimeUnit.NANOSECONDS.toMillis(executionTime));
        }
    }

    @Override
    public void close() throws IOException {
        try (RestClient restClient = this.restClient;){
            Sniffer sniffer = this.sniffer;
            Throwable throwable = null;
            if (sniffer != null) {
                if (throwable != null) {
                    try {
                        sniffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    sniffer.close();
                }
            }
        }
    }
}

