/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.IndexExistsWorkBuilder;

public class IndexExistsWork
extends SimpleElasticsearchWork<Boolean> {
    private static final ElasticsearchRequestSuccessAssessor RESULT_ASSESSOR = DefaultElasticsearchRequestSuccessAssessor.builder().ignoreErrorStatuses(404).build();

    protected IndexExistsWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Boolean generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
        return ElasticsearchClientUtils.isSuccessCode(response.getStatusLine().getStatusCode());
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements IndexExistsWorkBuilder {
        private final URLEncodedString indexName;

        public Builder(URLEncodedString indexName) {
            super(null, RESULT_ASSESSOR);
            this.indexName = indexName;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.head().pathComponent(this.indexName);
            return builder.build();
        }

        @Override
        public IndexExistsWork build() {
            return new IndexExistsWork(this);
        }
    }
}

