/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.aws.impl;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.protocol.HttpContext;
import org.hibernate.search.elasticsearch.aws.impl.AWSHeaders;
import org.hibernate.search.elasticsearch.aws.impl.AWSNormalization;
import org.hibernate.search.util.impl.CollectionHelper;
import uk.co.lucasweb.aws.v4.signer.Signer;
import uk.co.lucasweb.aws.v4.signer.credentials.AwsCredentials;

class AWSSigningRequestInterceptor
implements HttpRequestInterceptor {
    private static final Set<String> HEADERS_TO_SIGN = CollectionHelper.asImmutableSet((String[])new String[]{"host", "x-amz-date", "x-amz-content-sha256"});
    private final AwsCredentials credentials;
    private final String region;
    private final String service;

    public AWSSigningRequestInterceptor(String accessKey, String secretKey, String region, String service) {
        this.credentials = new AwsCredentials(accessKey, secretKey);
        this.region = region;
        this.service = service;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        LocalDateTime now = LocalDateTime.now(ZoneOffset.UTC);
        request.addHeader("x-amz-date", AWSHeaders.toAmzDate(now));
        String contentHash = this.computeContentHash(request);
        request.addHeader("x-amz-content-sha256", contentHash);
        request.addHeader("authorization", this.sign(request, contentHash));
    }

    private String computeContentHash(HttpRequest request) throws IOException {
        HttpEntity entity = this.getEntity(request);
        if (entity == null) {
            return DigestUtils.sha256Hex((String)"");
        }
        if (!entity.isRepeatable()) {
            throw new IllegalStateException("Cannot sign AWS requests with non-repeatable entities");
        }
        try (InputStream content = entity.getContent();){
            String string = DigestUtils.sha256Hex((InputStream)content);
            return string;
        }
    }

    private HttpEntity getEntity(HttpRequest request) throws IOException {
        if (request instanceof HttpEntityEnclosingRequest) {
            return ((HttpEntityEnclosingRequest)request).getEntity();
        }
        return null;
    }

    private String sign(HttpRequest request, String contentHash) {
        RequestLine requestLine = request.getRequestLine();
        uk.co.lucasweb.aws.v4.signer.HttpRequest signerRequestLine = new uk.co.lucasweb.aws.v4.signer.HttpRequest(requestLine.getMethod(), requestLine.getUri());
        Signer.Builder builder = Signer.builder().awsCredentials(this.credentials).region(this.region);
        for (String headerName : HEADERS_TO_SIGN) {
            Stream<String> stream = Arrays.stream(request.getHeaders(headerName)).map(Header::getValue);
            if ("host".equalsIgnoreCase(headerName)) {
                stream = stream.map(AWSNormalization::normalizeHost);
            }
            stream.forEach(v -> builder.header(headerName, v));
        }
        Signer signer = builder.build(signerRequestLine, this.service, contentHash);
        return signer.getSignature();
    }
}

