/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.bigdecimal;

import java.math.BigDecimal;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.dialect.SQLServer2008Dialect;
import org.hibernate.dialect.Sybase11Dialect;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.testing.SkipForDialect;

@SkipForDialect(value={SybaseASE15Dialect.class, Sybase11Dialect.class, SQLServer2008Dialect.class}, comment="Sybase and MSSQL don't support range large enough for this test")
public class NumericBigDecimalBridgeTest
extends SearchTestCase {
    public void testNumericFieldWithBigDecimals() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        Item item = new Item();
        item.setPrice(new BigDecimal(154.34));
        session.save((Object)item);
        tx.commit();
        tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Item.class).get();
        Query rootQuery = queryBuilder.bool().must(queryBuilder.range().onField("price").above((Object)10000L).createQuery()).must(queryBuilder.range().onField("price").below((Object)20000L).createQuery()).createQuery();
        List resultList = fullTextSession.createFullTextQuery(rootQuery, new Class[]{Item.class}).list();
        NumericBigDecimalBridgeTest.assertNotNull((Object)resultList);
        NumericBigDecimalBridgeTest.assertTrue((resultList.size() == 1 ? 1 : 0) != 0);
        tx.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Item.class};
    }

    public static class BigDecimalNumericFieldBridge
    extends NumericFieldBridge {
        private static final BigDecimal storeFactor = BigDecimal.valueOf(100L);

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            if (value != null) {
                BigDecimal decimalValue = (BigDecimal)value;
                long indexedValue = decimalValue.multiply(storeFactor).longValue();
                luceneOptions.addNumericFieldToDocument(name, (Object)indexedValue, document);
            }
        }

        public Object get(String name, Document document) {
            String fromLucene = document.get(name);
            BigDecimal storedBigDecimal = new BigDecimal(fromLucene);
            return storedBigDecimal.divide(storeFactor);
        }
    }

    @Entity
    @Indexed
    @Table(name="ITEM")
    public static class Item {
        @Id
        @GeneratedValue
        private int id;
        @Field
        @NumericField
        @FieldBridge(impl=BigDecimalNumericFieldBridge.class)
        private BigDecimal price;

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public int getId() {
            return this.id;
        }
    }
}

