/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import java.lang.annotation.ElementType;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.Search;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.id.PersonPK;
import org.hibernate.search.test.id.PersonPKBridge;
import org.hibernate.search.test.id.PlainPerson;

public class ProgrammaticEmbeddedItTest
extends SearchTestCase {
    public void testFieldBridge() throws Exception {
        PersonPK emmanuelPk = new PersonPK();
        emmanuelPk.setFirstName("Emmanuel");
        emmanuelPk.setLastName("Bernard");
        PlainPerson emmanuel = new PlainPerson();
        emmanuel.setFavoriteColor("Blue");
        emmanuel.setId(emmanuelPk);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.save((Object)emmanuel);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        List results = Search.getFullTextSession((Session)s).createFullTextQuery((Query)new TermQuery(new Term("id.lastName", "Bernard")), new Class[0]).list();
        ProgrammaticEmbeddedItTest.assertEquals((int)1, (int)results.size());
        emmanuel = (PlainPerson)results.get(0);
        emmanuel.setFavoriteColor("Red");
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        results = Search.getFullTextSession((Session)s).createFullTextQuery((Query)new TermQuery(new Term("id.lastName", "Bernard")), new Class[0]).list();
        ProgrammaticEmbeddedItTest.assertEquals((int)1, (int)results.size());
        emmanuel = (PlainPerson)results.get(0);
        ProgrammaticEmbeddedItTest.assertEquals((String)"Red", (String)emmanuel.getFavoriteColor());
        s.delete(results.get(0));
        tx.commit();
        s.close();
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        SearchMapping mapping = new SearchMapping();
        mapping.entity(PlainPerson.class).indexed().property("id", ElementType.FIELD).documentId().bridge(PersonPKBridge.class).property("", ElementType.FIELD).field();
        cfg.getProperties().put("hibernate.search.model_mapping", mapping);
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{PlainPerson.class};
    }
}

