/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend;

import java.io.File;
import junit.framework.Assert;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Projections;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.Clock;
import org.hibernate.search.test.SearchTestCase;

public class SyncBackendLongWorklistsStressTest
extends SearchTestCase {
    private static final int NUM_SAVED_ENTITIES = 40;

    public void testWorkLongerThanMaxQueueSize() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        for (int i = 0; i < 40; ++i) {
            Transaction tx = s.beginTransaction();
            Clock clock = new Clock(i, "brand num\u00b0 " + i);
            s.persist((Object)clock);
            tx.commit();
            s.clear();
        }
        Transaction tx = s.beginTransaction();
        Number count = (Number)s.createCriteria(Clock.class).setProjection(Projections.rowCount()).uniqueResult();
        Assert.assertEquals((int)40, (int)count.intValue());
        tx.commit();
        s.close();
        this.closeSessionFactory();
        this.openSessionFactory();
        s = Search.getFullTextSession((Session)this.openSession());
        tx = s.beginTransaction();
        int fullTextCount = s.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{Clock.class}).getResultSize();
        Assert.assertEquals((int)40, (int)fullTextCount);
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        File sub = this.getBaseIndexDir();
        cfg.setProperty("hibernate.search.default.indexBase", sub.getAbsolutePath());
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem");
        cfg.setProperty("hibernate.search.default.max_queue_length", "5");
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
        cfg.setProperty("hibernate.show_sql", "false");
        cfg.setProperty("hibernate.format_sql", "false");
    }
}

