/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend;

import org.hibernate.cfg.Configuration;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.impl.MutableSearchFactory;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.Clock;
import org.hibernate.search.test.SearchTestCase;
import org.junit.Test;

public class WorkQueueLengthConfiguredTest
extends SearchTestCase {
    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }

    @Test
    public void testNothingTest() {
        MutableSearchFactory searchFactory = (MutableSearchFactory)this.getSearchFactory();
        EntityIndexBinder indexBindingForEntity = searchFactory.getIndexBindingForEntity(Clock.class);
        IndexManager[] indexManagers = indexBindingForEntity.getIndexManagers();
        WorkQueueLengthConfiguredTest.assertEquals((int)1, (int)indexManagers.length);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexManagers[0];
        LuceneBackendQueueProcessor backend = (LuceneBackendQueueProcessor)indexManager.getBackendQueueProcessor();
        WorkQueueLengthConfiguredTest.assertEquals((int)5, (int)backend.getIndexResources().getMaxQueueLength());
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.max_queue_length", "5");
    }
}

