/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Assert;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.impl.SimpleIndexingProgressMonitor;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.batchindexing.LegacyCar;
import org.hibernate.search.test.batchindexing.LegacyCarPlant;
import org.hibernate.search.test.batchindexing.LegacyTire;

public class ProgressMonitorTest
extends SearchTestCase {
    FullTextSession fullTextSession;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.fullTextSession = Search.getFullTextSession((Session)this.openSession());
        ProgressMonitorTest.initializeData(this.fullTextSession);
    }

    public void testAllRelevantProgressMonitoringOperationsCalled() throws InterruptedException {
        DelegatingProgressMonitor monitor = new DelegatingProgressMonitor();
        this.fullTextSession.createIndexer(new Class[]{LegacyCar.class}).progressMonitor((MassIndexerProgressMonitor)monitor).startAndWait();
        this.fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{LegacyCar.class}).getResultSize();
        monitor.assertProgress();
    }

    private static void initializeData(FullTextSession fullTextSession) {
        Transaction transaction = fullTextSession.beginTransaction();
        LegacyCar[] cars = new LegacyCar[10];
        for (int i = 0; i < cars.length; ++i) {
            cars[i] = new LegacyCar();
            cars[i].setId("" + i);
            cars[i].setModel("model" + i);
            fullTextSession.persist((Object)cars[i]);
        }
        transaction.commit();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{LegacyCarPlant.class, LegacyCar.class, LegacyTire.class};
    }

    private static class DelegatingProgressMonitor
    implements MassIndexerProgressMonitor {
        MassIndexerProgressMonitor monitor;
        final AtomicLong totalCount = new AtomicLong();
        final AtomicLong finishedCount = new AtomicLong();
        final AtomicLong addedDocuments = new AtomicLong();

        DelegatingProgressMonitor() {
            this.monitor = new SimpleIndexingProgressMonitor(1);
        }

        public void documentsAdded(long increment) {
            this.addedDocuments.addAndGet(increment);
            this.monitor.documentsAdded(increment);
        }

        public void documentsBuilt(int number) {
            this.monitor.documentsBuilt(number);
        }

        public void entitiesLoaded(int size) {
            this.monitor.entitiesLoaded(size);
        }

        public void addToTotalCount(long count) {
            this.totalCount.addAndGet(count);
            this.monitor.addToTotalCount(count);
        }

        public void indexingCompleted() {
            this.finishedCount.incrementAndGet();
        }

        public void assertProgress() {
            Assert.assertEquals((String)"Unexpected number of added documents", (long)10L, (long)this.addedDocuments.get());
            Assert.assertEquals((String)"Unexpected total count", (long)10L, (long)this.totalCount.get());
            Assert.assertEquals((String)"Finished called more than once", (long)1L, (long)this.finishedCount.get());
        }
    }
}

