/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.optimizations;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.hibernate.Transaction;
import org.hibernate.collection.internal.PersistentBag;
import org.hibernate.collection.internal.PersistentSet;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.test.engine.optimizations.Catalog;
import org.hibernate.search.test.engine.optimizations.CatalogItem;
import org.hibernate.search.test.engine.optimizations.Consumer;
import org.hibernate.search.test.engine.optimizations.Item;
import org.hibernate.search.test.engine.optimizations.ItemClassBridge;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Test;

public class CollectionUpdateEventTest {
    @Test
    public void testWithClassBridge() {
        this.testScenario(true, 2, false);
    }

    @Test
    public void testWithoutClassBridge() {
        this.testScenario(false, 2, false);
    }

    @Test
    public void testWithNoEnoughDepth() {
        this.testScenario(true, 1, false);
    }

    @Test
    public void testWithDeepClassBridge() {
        this.testScenario(false, 1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScenario(boolean usingClassBridge, int depth, boolean usingClassbridgeOnEmbedded) {
        FullTextSessionBuilder fulltextSessionBuilder = this.createSearchFactory(usingClassBridge, depth, usingClassbridgeOnEmbedded);
        try {
            this.initializeData(fulltextSessionBuilder);
            FullTextSession fullTextSession = fulltextSessionBuilder.openFullTextSession();
            try {
                Catalog catalog = (Catalog)fullTextSession.get(Catalog.class, (Serializable)Long.valueOf(1L));
                PersistentSet catalogItems = (PersistentSet)catalog.getCatalogItems();
                PersistentBag consumers = (PersistentBag)catalog.getConsumers();
                ((BooleanAssert)Assertions.assertThat((boolean)consumers.wasInitialized()).as("consumers should not be initialized")).isFalse();
                ((BooleanAssert)Assertions.assertThat((boolean)consumers.wasInitialized()).as("catalogItems should not be initialized")).isFalse();
                this.updateCatalogsCollection(fullTextSession, catalog);
                if ((usingClassBridge || usingClassbridgeOnEmbedded) && depth > 1) {
                    ((BooleanAssert)Assertions.assertThat((boolean)catalogItems.wasInitialized()).as("catalogItems should have been initialized")).isTrue();
                } else {
                    ((BooleanAssert)Assertions.assertThat((boolean)catalogItems.wasInitialized()).as("catalogItems should not be initialized")).isFalse();
                }
            }
            finally {
                fullTextSession.close();
            }
        }
        finally {
            fulltextSessionBuilder.close();
        }
    }

    private FullTextSessionBuilder createSearchFactory(boolean defineClassBridge, int depth, boolean usingClassbridgeOnEmbedded) {
        FullTextSessionBuilder builder = new FullTextSessionBuilder().addAnnotatedClass(Catalog.class).addAnnotatedClass(CatalogItem.class).addAnnotatedClass(Consumer.class).addAnnotatedClass(Item.class);
        SearchMapping fluentMapping = builder.fluentMapping();
        EntityMapping catalogMapping = fluentMapping.entity(Catalog.class);
        if (usingClassbridgeOnEmbedded) {
            catalogMapping.classBridge(ItemClassBridge.class);
        }
        catalogMapping.property("catalogItems", ElementType.FIELD).containedIn().entity(CatalogItem.class).property("item", ElementType.FIELD).containedIn().property("catalog", ElementType.FIELD).indexEmbedded();
        if (defineClassBridge) {
            fluentMapping.entity(Item.class).classBridge(ItemClassBridge.class).indexed().property("catalogItems", ElementType.FIELD).indexEmbedded().depth(depth);
        } else {
            fluentMapping.entity(Item.class).indexed().property("catalogItems", ElementType.FIELD).indexEmbedded().depth(depth);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeData(FullTextSessionBuilder fulltextSessionBuilder) {
        FullTextSession fullTextSession = fulltextSessionBuilder.openFullTextSession();
        try {
            Transaction transaction = fullTextSession.beginTransaction();
            Catalog catalog = new Catalog();
            catalog.setCatalogId(1L);
            catalog.setName("parts");
            fullTextSession.persist((Object)catalog);
            for (int i = 0; i < 5; ++i) {
                Item item = new Item();
                item.setName("battery");
                fullTextSession.persist((Object)item);
                CatalogItem catalogItem = new CatalogItem();
                catalogItem.setCatalog(catalog);
                catalogItem.setItem(item);
                fullTextSession.persist((Object)catalogItem);
                item.getCatalogItems().add(catalogItem);
                fullTextSession.merge((Object)item);
                catalog.getCatalogItems().add(catalogItem);
                fullTextSession.merge((Object)catalog);
            }
            transaction.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    private void updateCatalogsCollection(FullTextSession fullTextSession, Catalog catalog) {
        Transaction transaction = fullTextSession.beginTransaction();
        Consumer consumer = new Consumer();
        consumer.setName("consumer");
        consumer.getCatalogs().add(catalog);
        fullTextSession.persist((Object)consumer);
        catalog.getConsumers().add(consumer);
        fullTextSession.merge((Object)catalog);
        transaction.commit();
    }
}

