/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.optimizations;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.test.engine.optimizations.Location;
import org.hibernate.search.test.engine.optimizations.LocationGroup;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.test.util.LeakingLuceneBackend;
import org.junit.Test;

public class CollectionUpdateEventsSecondTest {
    private LoadCountingListener loadCountListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScenario() {
        FullTextSessionBuilder fullTextSessionBuilder = this.createSearchFactory();
        try {
            this.assertOperationsPerformed(0);
            this.assertLocationsLoaded(0);
            this.initializeData(fullTextSessionBuilder);
            this.assertOperationsPerformed(5);
            this.assertLocationsLoaded(0);
            FullTextSession fullTextSession = fullTextSessionBuilder.openFullTextSession();
            this.assertFoundLocations(fullTextSession, "floor", 5);
            this.assertFoundLocations(fullTextSession, "airport", 0);
            fullTextSession.clear();
            try {
                this.addLocationToGroupCollection(fullTextSession);
                this.assertLocationsLoaded(0);
                this.assertOperationsPerformed(1);
                fullTextSession.clear();
                this.assertFoundLocations(fullTextSession, "floor", 6);
                this.assertFoundLocations(fullTextSession, "airport", 0);
                this.updateLocationGroupName(fullTextSession);
                fullTextSession.clear();
                this.assertFoundLocations(fullTextSession, "floor", 0);
                this.assertFoundLocations(fullTextSession, "airport", 6);
                this.assertLocationsLoaded(6);
                this.assertOperationsPerformed(6);
            }
            finally {
                fullTextSession.close();
            }
        }
        finally {
            fullTextSessionBuilder.close();
        }
    }

    private void assertLocationsLoaded(int expectedLoads) {
        Assert.assertEquals((int)expectedLoads, (int)this.loadCountListener.locationLoadEvents.getAndSet(0));
    }

    private void assertOperationsPerformed(int expectedOperationCount) {
        List lastProcessedQueue = LeakingLuceneBackend.getLastProcessedQueue();
        Assert.assertEquals((int)expectedOperationCount, (int)lastProcessedQueue.size());
        LeakingLuceneBackend.reset();
    }

    private FullTextSessionBuilder createSearchFactory() {
        this.loadCountListener = new LoadCountingListener();
        FullTextSessionBuilder builder = new FullTextSessionBuilder().setProperty("hibernate.search.default.worker.backend", LeakingLuceneBackend.class.getName()).addAnnotatedClass(LocationGroup.class).addAnnotatedClass(Location.class).addLoadEventListener(this.loadCountListener);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeData(FullTextSessionBuilder fulltextSessionBuilder) {
        FullTextSession fullTextSession = fulltextSessionBuilder.openFullTextSession();
        try {
            Transaction transaction = fullTextSession.beginTransaction();
            LocationGroup group = new LocationGroup("Floor 1");
            fullTextSession.persist((Object)group);
            for (int i = 0; i < 5; ++i) {
                Location location = new Location("Room 10" + i);
                fullTextSession.persist((Object)location);
                group.getLocations().add(location);
                location.setLocationGroup(group);
                fullTextSession.merge((Object)group);
            }
            transaction.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    private void addLocationToGroupCollection(FullTextSession fullTextSession) {
        Transaction transaction = fullTextSession.beginTransaction();
        LocationGroup group = (LocationGroup)fullTextSession.get(LocationGroup.class, (Serializable)Long.valueOf(1L));
        Location location = new Location("New Room");
        fullTextSession.persist((Object)location);
        group.getLocations().add(location);
        location.setLocationGroup(group);
        transaction.commit();
    }

    private void updateLocationGroupName(FullTextSession fullTextSession) {
        Transaction transaction = fullTextSession.beginTransaction();
        LocationGroup group = (LocationGroup)fullTextSession.get(LocationGroup.class, (Serializable)Long.valueOf(1L));
        LocationGroup locationGroup = (LocationGroup)fullTextSession.merge((Object)group);
        locationGroup.setName("Airport");
        transaction.commit();
    }

    private void assertFoundLocations(FullTextSession fullTextSession, String locationGroupName, int expectedFoundLocations) {
        Transaction transaction = fullTextSession.beginTransaction();
        TermQuery luceneQuery = new TermQuery(new Term("locationGroup.name", locationGroupName));
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)luceneQuery, new Class[]{Location.class});
        int resultSize = fullTextQuery.getResultSize();
        transaction.commit();
        Assert.assertEquals((int)expectedFoundLocations, (int)resultSize);
    }

    public static class LoadCountingListener
    implements LoadEventListener {
        final AtomicInteger locationLoadEvents = new AtomicInteger();

        public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
            if (Location.class.getName().equals(event.getEntityClassName())) {
                this.locationLoadEvents.incrementAndGet();
            }
        }
    }
}

