/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.hibernate.search.SearchException;
import org.hibernate.search.test.filter.ExcludeAllFilter;

public class InstanceBasedExcludeAllFilter
extends Filter
implements Serializable {
    private static volatile int constructorCount = 0;

    public InstanceBasedExcludeAllFilter() {
        ++constructorCount;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        ExcludeAllFilter.verifyItsAReadOnlySegmentReader(reader);
        return DocIdSet.EMPTY_DOCIDSET;
    }

    public static void reset() {
        constructorCount = 0;
    }

    public static void assertConstructorInvoked(int times) {
        if (constructorCount != times) {
            throw new SearchException("test failed, constructor invoked " + constructorCount + ", expected " + times);
        }
    }
}

