/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.indexingStrategy;

import java.io.Serializable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.test.AlternateDocument;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestCase;

public class ManualIndexingStrategyTest
extends SearchTestCase {
    public void testMultipleEntitiesPerIndex() throws Exception {
        Session s = this.getSessions().openSession();
        s.getTransaction().begin();
        Document document = new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah");
        s.persist((Object)document);
        s.flush();
        s.persist((Object)new AlternateDocument(document.getId(), "Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        ManualIndexingStrategyTest.assertEquals((int)0, (int)this.getDocumentNbr());
        s = this.getSessions().openSession();
        s.getTransaction().begin();
        s.delete(s.get(AlternateDocument.class, (Serializable)document.getId()));
        s.delete(s.createCriteria(Document.class).uniqueResult());
        s.getTransaction().commit();
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDocumentNbr() throws Exception {
        IndexReader reader = IndexReader.open((Directory)this.getDirectory(Document.class), (boolean)false);
        try {
            int n = reader.numDocs();
            return n;
        }
        finally {
            reader.close();
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class, AlternateDocument.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.indexing_strategy", "manual");
    }
}

