/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.proxy;

import java.io.Serializable;
import java.util.HashSet;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.proxy.Author;
import org.hibernate.search.test.proxy.Book;
import org.hibernate.search.test.proxy.Comment;
import org.hibernate.search.test.proxy.IAuthor;
import org.hibernate.search.test.proxy.IComment;
import org.hibernate.search.test.proxy.IProfile;
import org.hibernate.search.test.proxy.Profile;

public class ProxyTest
extends SearchTestCase {
    public void testProxy() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
        Author author = new Author();
        author.setBook(book);
        author.setName("John Doe");
        HashSet<IAuthor> authors = new HashSet<IAuthor>();
        authors.add(author);
        book.setAuthors(authors);
        session.save((Object)book);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        IAuthor loadedAuthor = (IAuthor)session.get(Author.class, (Serializable)author.getId());
        session.delete((Object)loadedAuthor);
        tx.commit();
        session.close();
    }

    public void testDeleteProxy() throws Exception {
        this.createTestData();
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        IComment c = (IComment)s.get(Comment.class, (Serializable)Integer.valueOf(2));
        s.delete((Object)c);
        tx.commit();
        s.close();
    }

    public void createTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Profile p = new Profile();
        p.setId(1);
        s.save((Object)p);
        Comment c1 = new Comment();
        c1.setId(2);
        c1.setProfile((IProfile)s.get(Profile.class, (Serializable)Integer.valueOf(1)));
        c1.setContent("c1");
        c1.setRootComment(null);
        s.save((Object)c1);
        Comment c2 = new Comment();
        c2.setId(3);
        c2.setProfile((IProfile)s.get(Profile.class, (Serializable)Integer.valueOf(1)));
        c2.setContent("c2");
        c2.setRootComment(c1);
        s.save((Object)c2);
        Comment c3 = new Comment();
        c3.setId(4);
        c3.setProfile((IProfile)s.get(Profile.class, (Serializable)Integer.valueOf(1)));
        c3.setContent("c3");
        c3.setRootComment(c1);
        s.save((Object)c3);
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Author.class, Comment.class, Profile.class};
    }
}

